//
//  Created by  fred on 2017/1/12.
//  Copyright © 2016年 Alibaba. All rights reserved.
//

package cn.com.duiba.tool.ruxin;

import com.alibaba.cloudapi.sdk.client.ApacheHttpClient;
import com.alibaba.cloudapi.sdk.constant.HttpConstant;
import com.alibaba.cloudapi.sdk.enums.HttpConnectionModel;
import com.alibaba.cloudapi.sdk.enums.HttpMethod;
import com.alibaba.cloudapi.sdk.enums.ParamPosition;
import com.alibaba.cloudapi.sdk.enums.Scheme;
import com.alibaba.cloudapi.sdk.exception.SdkException;
import com.alibaba.cloudapi.sdk.model.ApiCallback;
import com.alibaba.cloudapi.sdk.model.ApiRequest;
import com.alibaba.cloudapi.sdk.model.ApiResponse;
import com.alibaba.cloudapi.sdk.model.HttpClientBuilderParams;
import com.alibaba.cloudapi.sdk.util.ApiRequestMaker;
import com.alibaba.cloudapi.sdk.util.HttpCommonUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


public class RuxinHttpApiClientpublicActivityGroup extends ApacheHttpClient {
//    public final static String HOST = "api.cn.nuskin.com";
//    public final static String HOST = "1000106.cn.nuskin.com/nuskin-cn-service-marketing/";

    static RuxinHttpApiClientpublicActivityGroup instance = new RuxinHttpApiClientpublicActivityGroup();

    public static RuxinHttpApiClientpublicActivityGroup getInstance() {
        return instance;
    }

    public static final ObjectMapper mapper = new ObjectMapper();

    public void init(HttpClientBuilderParams httpClientBuilderParams, String HOST) {
        httpClientBuilderParams.setScheme(Scheme.HTTP);
        httpClientBuilderParams.setHost(HOST);
        super.init(httpClientBuilderParams);
    }


    public void P31promotion_duiba_addIntegral(Map<String, String> authParams, ApiCallback callback, String path) {
//        String path = "/api/v1/yundt/trade/promotion/duiba/addIntegral";
        ApiRequest request = new ApiRequest(HttpMethod.GET, path);
        request.addParam("appKey", authParams.get("appKey"), ParamPosition.QUERY, true);
        request.addParam("uid", authParams.get("uid"), ParamPosition.QUERY, true);
        request.addParam("credits", authParams.get("credits"), ParamPosition.QUERY, true);
        request.addParam("type", authParams.get("type"), ParamPosition.QUERY, true);
        request.addParam("orderNum", authParams.get("orderNum"), ParamPosition.QUERY, true);
        request.addParam("subOrderNum", authParams.get("subOrderNum"), ParamPosition.QUERY, false);
        request.addParam("timestamp", authParams.get("timestamp"), ParamPosition.QUERY, true);
        request.addParam("description", authParams.get("description"), ParamPosition.QUERY, false);
        request.addParam("ip", authParams.get("ip"), ParamPosition.QUERY, false);
        request.addParam("sign", authParams.get("sign"), ParamPosition.QUERY, true);


        sendAsyncRequest(request, callback);
    }

    public ApiResponse P31promotion_duiba_addIntegralSyncMode(Map<String, String> authParams, String path) {
//        String path = "/api/v1/yundt/trade/promotion/duiba/addIntegral";
        ApiRequest request = new ApiRequest(HttpMethod.GET, path);
        request.addParam("appKey", authParams.get("appKey"), ParamPosition.QUERY, true);
        request.addParam("uid", authParams.get("uid"), ParamPosition.QUERY, true);
        request.addParam("credits", authParams.get("credits"), ParamPosition.QUERY, true);
        request.addParam("type", authParams.get("type"), ParamPosition.QUERY, true);
        request.addParam("orderNum", authParams.get("orderNum"), ParamPosition.QUERY, true);
        request.addParam("subOrderNum", authParams.get("subOrderNum"), ParamPosition.QUERY, false);
        request.addParam("timestamp", authParams.get("timestamp"), ParamPosition.QUERY, true);
        request.addParam("description", authParams.get("description"), ParamPosition.QUERY, false);
        request.addParam("ip", authParams.get("ip"), ParamPosition.QUERY, false);
        request.addParam("sign", authParams.get("sign"), ParamPosition.QUERY, true);



        return sendSyncRequest(request);
    }

    public void P32promotion_duiba_deductIntegral(Map<String, String> authParams, ApiCallback callback, String path) {
//        String path = "/api/v1/yundt/trade/promotion/duiba/deductIntegral";
        ApiRequest request = new ApiRequest(HttpMethod.GET, path);
        request.addParam("uid", authParams.get("uid"), ParamPosition.QUERY, true);
        request.addParam("credits", authParams.get("credits"), ParamPosition.QUERY, true);
        request.addParam("itemCode", authParams.get("itemCode"), ParamPosition.QUERY, false);
        request.addParam("appKey", authParams.get("appKey"), ParamPosition.QUERY, true);
        request.addParam("timestamp", authParams.get("timestamp"), ParamPosition.QUERY, true);
        request.addParam("description", authParams.get("description"), ParamPosition.QUERY, true);
        request.addParam("orderNum", authParams.get("orderNum"), ParamPosition.QUERY, true);
        request.addParam("type", authParams.get("type"), ParamPosition.QUERY, true);
        request.addParam("facePrice", authParams.get("facePrice"), ParamPosition.QUERY, false);
        request.addParam("actualPrice", authParams.get("actualPrice"), ParamPosition.QUERY, true);
        request.addParam("ip", authParams.get("ip"), ParamPosition.QUERY, false);
        request.addParam("qq", authParams.get("qq"), ParamPosition.QUERY, false);
        request.addParam("phone", authParams.get("phone"), ParamPosition.QUERY, false);
        request.addParam("alipay", authParams.get("alipay"), ParamPosition.QUERY, false);
        request.addParam("waitAudit", authParams.get("waitAudit"), ParamPosition.QUERY, false);
        request.addParam("params", authParams.get("params"), ParamPosition.QUERY, false);
        request.addParam("sign", authParams.get("sign"), ParamPosition.QUERY, true);


        sendAsyncRequest(request, callback);
    }

    public ApiResponse P32promotion_duiba_deductIntegralSyncMode(Map<String, String> authParams,  String path) {
//        String path = "/api/v1/yundt/trade/promotion/duiba/deductIntegral";
        ApiRequest request = new ApiRequest(HttpMethod.GET, path);
        request.addParam("uid", authParams.get("uid"), ParamPosition.QUERY, true);
        request.addParam("credits", authParams.get("credits"), ParamPosition.QUERY, true);
        request.addParam("itemCode", authParams.get("itemCode"), ParamPosition.QUERY, false);
        request.addParam("appKey", authParams.get("appKey"), ParamPosition.QUERY, true);
        request.addParam("timestamp", authParams.get("timestamp"), ParamPosition.QUERY, true);
        request.addParam("description", authParams.get("description"), ParamPosition.QUERY, true);
        request.addParam("orderNum", authParams.get("orderNum"), ParamPosition.QUERY, true);
        request.addParam("type", authParams.get("type"), ParamPosition.QUERY, true);
        request.addParam("facePrice", authParams.get("facePrice"), ParamPosition.QUERY, false);
        request.addParam("actualPrice", authParams.get("actualPrice"), ParamPosition.QUERY, true);
        request.addParam("ip", authParams.get("ip"), ParamPosition.QUERY, false);
        request.addParam("qq", authParams.get("qq"), ParamPosition.QUERY, false);
        request.addParam("phone", authParams.get("phone"), ParamPosition.QUERY, false);
        request.addParam("alipay", authParams.get("alipay"), ParamPosition.QUERY, false);
        request.addParam("waitAudit", authParams.get("waitAudit"), ParamPosition.QUERY, false);
        request.addParam("params", authParams.get("params"), ParamPosition.QUERY, false);
        request.addParam("sign", authParams.get("sign"), ParamPosition.QUERY, true);
        return sendSyncRequest(request);
    }

    public ApiResponse P33promotion_duiba_exchangeResult(Map<String, String> param,String path) {
//        String path = "/api/v1/yundt/trade/promotion/duiba/exchangeResult";
        ApiRequest request = new ApiRequest(HttpMethod.GET, path);
        request.addParam("appKey", param.get("appKey"), ParamPosition.QUERY, true);
        request.addParam("timestamp", param.get("timestamp"), ParamPosition.QUERY, true);
        request.addParam("uid", param.get("uid"), ParamPosition.QUERY, true);
        request.addParam("success", param.get("success"), ParamPosition.QUERY, true);
        request.addParam("errorMessage", param.get("errorMessage"), ParamPosition.QUERY, false);
        request.addParam("orderNum", param.get("orderNum"), ParamPosition.QUERY, true);
        request.addParam("bizId", param.get("bizId"), ParamPosition.QUERY, false);
        request.addParam("sign", param.get("sign"), ParamPosition.QUERY, true);


        return sendSyncRequest(request);
    }

    public ApiResponse P33promotion_duiba_exchangeResultSyncMode(String appKey, String timestamp, String uid, String success, String errorMessage, String orderNum, String bizId, String sign) {
        String path = "/api/v1/yundt/trade/promotion/duiba/exchangeResult";
        ApiRequest request = new ApiRequest(HttpMethod.GET, path);
        request.addParam("appKey", appKey, ParamPosition.QUERY, true);
        request.addParam("timestamp", timestamp, ParamPosition.QUERY, true);
        request.addParam("uid", uid, ParamPosition.QUERY, true);
        request.addParam("success", success, ParamPosition.QUERY, true);
        request.addParam("errorMessage", errorMessage, ParamPosition.QUERY, false);
        request.addParam("orderNum", orderNum, ParamPosition.QUERY, true);
        request.addParam("bizId", bizId, ParamPosition.QUERY, false);
        request.addParam("sign", sign, ParamPosition.QUERY, true);


        return sendSyncRequest(request);
    }


}