package cn.com.duiba.order.center.api.remoteservice.amb;

import java.util.List;

import cn.com.duiba.order.center.api.dto.amb.AmbDeveloperWithdrawCashAuditDto;
import cn.com.duiba.order.center.api.vo.AmbDeveloperWithdrawCashAuditVO;

public interface RemoteAmbDeveloperWithdrawCashAuditService {

	/**
     * 新增审核信息
     * @param ambDeveloperWithdrawCashAuditDO
     */
    public AmbDeveloperWithdrawCashAuditDto insert(AmbDeveloperWithdrawCashAuditDto ambDeveloperWithdrawCashAuditDO);
    
    /**
     * 根据ID查询
     * @param id
     * @return
     */
    public AmbDeveloperWithdrawCashAuditDto findById(Long id);
    
    /**
     * 获取有效的审核通过的审核信息
     * @param developerId 
     * @param cashType 提现类型
     * @return
     */
    public AmbDeveloperWithdrawCashAuditDto findValidPassAudit(Long developerId,String cashType);
    
    /**
     * 获取正在审核的信息
     * @param developerId
     * @return
     */
    public AmbDeveloperWithdrawCashAuditDto findAuditing(Long developerId,String cashType);
    
    /**
     * 禁用所有效的审核
     * @param developerId
     * @param cashType
     */
    public void disableValidPassAudit(Long developerId,String cashType);
    
    /**
     * 将审核材料的状态由创建更新为待审核
     * @param auditId
     * @return
     */
    public int updateStatusCreateToWait(Long auditId);

    /**
     * @param auditIds
     */
    public List<AmbDeveloperWithdrawCashAuditDto> findByIds(List<Long> auditIds);
    
    public List<AmbDeveloperWithdrawCashAuditVO> findPageList(String email, String status, Integer offset, Integer max);

    public Long findPageCount(String email, String status);
    
    public int updateConfirmAudit(Long id);
    
    public int updateRejectAudit(Long id, String description);
}
