package cn.com.duiba.order.center.api.remoteservice.amb;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.order.center.api.dto.amb.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.vo.AmbSubOrdersVO;

public interface RemoteAmbSubOrdersService {
	
	public AmbSubOrdersDto createSubOrders(AmbSubOrdersDto order);

	public AmbSubOrdersDto findSubOrderById(Long subId);

	public int updatePayChannelIdBySubId(Long payChannelId, Long id);

	public int updateSettleStatusNoneBySubId(Long subId, Long consumerPayBackPrice);

	public int updateSettleStatusSettleBySubId(Long subId);

	public int updateSettleStatusWaitSettleBySubId(Long subId);

	public int updateShipStatus4WaitShip(Long subId);

	public int updateShipStatus4Shiped(Long subId);

	public int updateShipStatus4Received(Long subId);
	
	public int updateShipStatus4ReceivedAtCreate(Long subId);

	public int updateRemarkBySubId(Long subId, String remark);
	
	public List<AmbSubOrdersDto> findByIds(List<Long> Ids);

	public int updateAmbPostsaleOrderIdById(Long subId, Long postsaleOrderId);
	
	public int updateConsumerPayBackPriceById(Long id, Long consumerPayBackPrice);
	
	public List<AmbSubOrdersDto> findWaitSettleOrderList(Map<String,Object> params);
	
	public Long findWaitSettleOrderCount(Map<String,Object> params);
	
	public Long findWaitSettleMoney(Long developerId);
	
	public AmbSubOrdersDto findByOrderId(Long orderId);
	
	public List<AmbSubOrdersVO> findPageList(Date startDate,Date endDate,Long relationId,Integer offset,Integer max);

    public Long findPageCount(Date startDate,Date endDate,Long relationId,Integer offset,Integer max);

}
