package cn.com.duiba.order.center.api.remoteservice.crecord;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.order.center.api.dto.crecord.ConsumerExchangeRecordDto;

public interface RemoteConsumerExchangeRecordService {
	
	public long getSequenceID();
	
	public ConsumerExchangeRecordDto find(Long id, long consumerId);
	
	public ConsumerExchangeRecordDto insert(ConsumerExchangeRecordDto consumerExchangeRecordDO);
	
	public int updateSwitchs(Long id, Long switchs, Long orderId, long consumerId);
	
	public int updateOrderId(Long id, Long orderId, long consumerId);
	
	public int updateJson(Long id, String json, long consumerId);
	
	public int updateOverDue(Long id,Date overDue,Long consumerId);
	
	public List<ConsumerExchangeRecordDto> findConsumerExchangeRecord(Map<String, Object> queryMap, long consumerId);
	
	public List<ConsumerExchangeRecordDto> findConsumerExchangeRecordValid(Map<String, Object> queryMap, long consumerId);
	
	public List<ConsumerExchangeRecordDto> findConsumerExchangeRecordInvalid(Map<String,Object> queryMap,long consumerId);
	
	public ConsumerExchangeRecordDto findByOrderId(Long orderId, Long consumerId);
	
	public ConsumerExchangeRecordDto findByRelationIdAndType(Long relationId, Integer type, Long consumerId);
	
	public ConsumerExchangeRecordDto findGameByRelationIdAndType(Long relationId, Integer type, Long consumerId);
	
	public ConsumerExchangeRecordDto findGuessByRelationIdAndType(Long relationId, Integer type, Long consumerId);
	
	public List<ConsumerExchangeRecordDto> findConsumerExchangeRecordPptv(Long consumerId, Long minId, Integer max);
	
	public List<ConsumerExchangeRecordDto> findGameRecord(Long consumerId, Integer type, Integer offset, Integer max);
	
	public ConsumerExchangeRecordDto findOneRecordInvalid(long consumerId);
}
