package cn.com.duiba.order.center.api.remoteservice.orders_faster;

import cn.com.duiba.order.center.api.dto.OrdersPageInfoDto;
import cn.com.duiba.order.center.api.dto.orders_faster.OrdersFasterDto;
import cn.com.duiba.order.center.api.dto.queryparam.AabnormalOrderQueryDto;
import cn.com.duiba.order.center.api.vo.DevAbnormalOrderVO;
import cn.com.duiba.order.center.api.vo.OrderFasterVO;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/7/20.
 */
public interface RemoteOrdersFasterBizReadService {

    public Integer getProcessingOrdersCount(Long appId, Date startDay, Date endDay);

    public Integer getAuditOrdersCount(Long appId);

    public Integer getVirtualAbnormalOrdersCount(Long appId,Date delayTime);

    public Long getWaitOrdersCount(Long appId);

    public Map<String, Long> getTimeOutRowAndMax(Map<String, Object> queryMap);

    public List<Long> findTimeOutExportOrderIds(Map<String,Object> queryMap);

    public List<Long> findWaitExportOrderIds(Map<String, Object> queryMap);

    public Map<String, Long> getWaitRowAndMax(Map<String, Object> queryMap);

    public List<DevAbnormalOrderVO> findVirtualAbnormalOrder(Map<String,Object> queryMap);

    public Long findVirtualAbnormalOrderCount(Map<String,Object> queryMap);

    public List<OrderFasterVO> findDevWaitOrderFast(Map<String,Object> paramMap);

    public Long findDevWaitOrderFastCount(Map<String, Object> paramMap);

    public List<OrdersFasterDto> findSencodeKillOrder(Map<String,Object> queryMap);

    public Long findSencodeKillOrderCount(Map<String,Object> queryMap);

    public List<OrdersFasterDto> findTimeoutOrder(AabnormalOrderQueryDto queryEntity);

    public Long findTimeoutOrderCount(AabnormalOrderQueryDto queryEntity);

    public List<OrdersFasterDto> findLotteryTimeoutOrder(AabnormalOrderQueryDto queryEntity);

    public Long findLotteryTimeoutOrderCount(AabnormalOrderQueryDto queryEntity);

    public List<OrdersFasterDto> findHdToolTimeoutOrder(AabnormalOrderQueryDto queryEntity);

    public Long findHdToolTimeoutOrderCount(AabnormalOrderQueryDto queryEntity);

    public List<OrderFasterVO> findOrderFastShippNew(OrdersPageInfoDto pageInfo);

    public Long findOrderFastShippNewCount(OrdersPageInfoDto pageInfo);

    public List<OrderFasterVO> findAuditOrderFast(Map<String,Object> paramMap);

    public Long findAuditOrderFastCount(Map<String,Object> paramMap);

    public List<Long> findExportShippDuibaOrders(OrdersPageInfoDto pageInfo);

    public Long getShippDuibaMax(OrdersPageInfoDto pageInfo);

    public Long getShippDuibaCount(OrdersPageInfoDto pageInfo);

    List<OrderFasterVO> findDevWaitOrderFastByOrderNum(Map<String, Object> paramMap);

}
