package cn.com.duiba.order.center.api.dto;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.tools.DuibaEvent;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by yansen on 16/8/15.
 */
public class OrderCreateContext implements Serializable{

    private static final long serialVersionUID = 2957757651367585222L;
    private DuibaEvent.RequestParams params;
    private Integer actualPrice;
    private ItemKey key;
    private ConsumerDO consumer;
    private OrdersDto ordersDto;
    private String chargeMode;
    private Map<String,Object> paramsMap;
    private SupplierProductDto supplierProduct;

    public OrderCreateContext(DuibaEvent.RequestParams params, ItemKey key, Integer actualPrice, ConsumerDO consumer,OrdersDto ordersDto,SupplierProductDto supplierProduct,String chargeMode) {
        this.params = params;
        this.key = key;
        this.actualPrice = actualPrice;
        this.consumer = consumer;
        this.ordersDto=ordersDto;
        this.supplierProduct=supplierProduct;
        this.chargeMode=chargeMode;
    }

    public DuibaEvent.RequestParams getParams() {
        return params;
    }

    public void setParams(DuibaEvent.RequestParams params) {
        this.params = params;
    }

    public Integer getActualPrice() {
        return actualPrice;
    }

    public void setActualPrice(Integer actualPrice) {
        this.actualPrice = actualPrice;
    }

    public ItemKey getKey() {
        return key;
    }

    public void setKey(ItemKey key) {
        this.key = key;
    }

    public ConsumerDO getConsumer() {
        return consumer;
    }

    public void setConsumer(ConsumerDO consumer) {
        this.consumer = consumer;
    }

    public OrdersDto getOrdersDto() {
        return ordersDto;
    }

    public void setOrdersDto(OrdersDto ordersDto) {
        this.ordersDto = ordersDto;
    }

    public Map<String, Object> getParamsMap() {
        return paramsMap;
    }

    public void addParam(String key,Object value){
        if(paramsMap==null||paramsMap.isEmpty()){
            paramsMap=new HashMap<>();
        }
        paramsMap.put(key,value);
    }

    public SupplierProductDto getSupplierProduct() {
        return supplierProduct;
    }

    public void setSupplierProduct(SupplierProductDto supplierProduct) {
        this.supplierProduct = supplierProduct;
    }

    public String getChargeMode() {
        return chargeMode;
    }

    public void setChargeMode(String chargeMode) {
        this.chargeMode = chargeMode;
    }
}
