package cn.com.duiba.order.center.api.dto;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

public class TurntableOrderDto implements Serializable {
	private static final long serialVersionUID = 6126120163417025325L;
	public static final String PREFIX_ORDER = "turntable-";

	public static final int PrizeTypeThanks = 0;// 谢谢参与
	public static final int PrizeTypeTryAgain = 1;// 再来一次
	public static final int PrizeTypeAlipay = 2; // 支付宝
	public static final int PrizeTypeQB = 3;// QB
	public static final int PrizeTypeCoupon = 4;// 优惠劵
	public static final int PrizeTypeObject = 5;// 实物
	public static final int PrizeTypePhonebill = 6;// 话费
	public static final int PrizeTypeVirtual = 7;//虚拟商品

	public static final int ExchangeStatusCreate = 0;
	public static final int ExchangeStatusWait = 1;// 待兑换
	public static final int ExchangeStatusSuccess = 2; // 领奖成功
	public static final int ExchangeStatusFail = 3;// 领奖失败，可以再次尝试
	public static final int ExchangeStatusOverdue = 4;// 未领奖，过期

	public static final int StatusCreate = 0; // 创建
	public static final int StatusSuccess = 1;// 处理成功
	public static final int StatusFail = 2;// 处理失败

	private Long id;
	private String orderNum;
	private Long operatingActivityId;
	private Long appId;
	private Long consumerId;
	private Long credits;
	private Long turntableOptionsId;
	private Long appItemId;
	private Long itemId;
	private String prizeName;// 奖项名称 冗余，防止中途修改兑换项 找不到奖项名字
	private Integer prizeType;// 中奖类型
	private Integer prizeFacePrice;
	private String prizeDegree;
	private String developerBizId;
	private Long couponId;
	private Integer status;
	private String error4Admin;
	private String error4Developer;
	private String error4Consumer;
	private Long tryAgainTurntableOrderId; 
	private Integer exchangeStatus;// 领奖状态
	private Long orderId;

	private Integer notify; // 通知状态 0--尚未通知 1-5通知次数 999--通知成功 同orders.notify

	// 此字段临时使用，不不存进入数据库！！！
	private Long consumerExchangeRecordId;

	private String ip;

	private Date gmtCreate;
	private Date gmtModified;

	public TurntableOrderDto() {
	}

	public TurntableOrderDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	public TurntableOrderDto(boolean init4insert) {
		if (init4insert) {
			prizeType = PrizeTypeThanks;
			prizeFacePrice = 0;
			status = StatusCreate;
			exchangeStatus = ExchangeStatusCreate;
			notify = 0;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
			status=StatusCreate;
		}
	}

	public static synchronized String generate() {
		Date date = new Date();
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");

		long STEP = 10000;
		int timesInt = new Random().nextInt(100);
		Long atomic = new Long(timesInt * STEP);

		String f = format.format(date);

		Long value = ++atomic;
		if (atomic >= 10000000) {
			atomic = new Long(timesInt * STEP);
		}
		String v = value.toString();
		while (v.length() < 8) {
			v = "0" + v;
		}

		return PREFIX_ORDER + f + v;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getOrderNum() {
		return orderNum;
	}

	public void setOrderNum(String orderNum) {
		this.orderNum = orderNum;
	}

	public Long getOperatingActivityId() {
		return operatingActivityId;
	}

	public void setOperatingActivityId(Long operatingActivityId) {
		this.operatingActivityId = operatingActivityId;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public Long getCredits() {
		return credits;
	}

	public void setCredits(Long credits) {
		this.credits = credits;
	}

	public Long getTurntableOptionsId() {
		return turntableOptionsId;
	}

	public void setTurntableOptionsId(Long turntableOptionsId) {
		this.turntableOptionsId = turntableOptionsId;
	}

	public Long getAppItemId() {
		return appItemId;
	}

	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}

	public String getPrizeName() {
		return prizeName;
	}

	public void setPrizeName(String prizeName) {
		this.prizeName = prizeName;
	}

	public Integer getPrizeType() {
		return prizeType;
	}

	public void setPrizeType(Integer prizeType) {
		this.prizeType = prizeType;
	}

	public Integer getPrizeFacePrice() {
		return prizeFacePrice;
	}

	public void setPrizeFacePrice(Integer prizeFacePrice) {
		this.prizeFacePrice = prizeFacePrice;
	}
	
	public String getPrizeDegree() {
		return prizeDegree;
	}

	public void setPrizeDegree(String prizeDegree) {
		this.prizeDegree = prizeDegree;
	}

	public String getDeveloperBizId() {
		return developerBizId;
	}

	public void setDeveloperBizId(String developerBizId) {
		this.developerBizId = developerBizId;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public String getError4Admin() {
		return error4Admin;
	}

	public void setError4Admin(String error4Admin) {
		if(error4Admin!=null&&error4Admin.length()>200){
			error4Admin = error4Admin.substring(0,200);
		}
		this.error4Admin = error4Admin;
	}

	public String getError4Developer() {
		return error4Developer;
	}

	public void setError4Developer(String error4Developer) {
		if(error4Developer!=null&&error4Developer.length()>200){
			error4Developer = error4Developer.substring(0,200);
		}
		this.error4Developer = error4Developer;
	}

	public String getError4Consumer() {
		return error4Consumer;
	}

	public void setError4Consumer(String error4Consumer) {
		if(error4Consumer!=null&&error4Consumer.length()>200){
			error4Consumer = error4Consumer.substring(0,200);
		}
		this.error4Consumer = error4Consumer;
	}

	public Integer getExchangeStatus() {
		return exchangeStatus;
	}

	public void setExchangeStatus(Integer exchangeStatus) {
		this.exchangeStatus = exchangeStatus;
	}

	public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Integer getNotify() {
		return notify;
	}

	public void setNotify(Integer notify) {
		this.notify = notify;
	}

	public Long getConsumerExchangeRecordId() {
		return consumerExchangeRecordId;
	}

	public void setConsumerExchangeRecordId(Long consumerExchangeRecordId) {
		this.consumerExchangeRecordId = consumerExchangeRecordId;
	}
	
	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getCouponId() {
		return couponId;
	}

	public void setCouponId(Long couponId) {
		this.couponId = couponId;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Long getTryAgainTurntableOrderId() {
		return tryAgainTurntableOrderId;
	}

	public void setTryAgainTurntableOrderId(Long tryAgainTurntableOrderId) {
		this.tryAgainTurntableOrderId = tryAgainTurntableOrderId;
	}

	public static int itemTypeToTurntableOrderType(String type) {
		if (ItemDto.TypePhonebill.equals(type)) {
			return PrizeTypePhonebill;
		} else if (ItemDto.TypeQB.equals(type)) {
			return PrizeTypeQB;
		} else if (ItemDto.TypeCoupon.equals(type)) {
			return PrizeTypeCoupon;
		} else if (ItemDto.TypeAlipay.equals(type)) {
			return PrizeTypeAlipay;
		} else if (ItemDto.TypeObject.equals(type)) {
			return PrizeTypeObject;
		} else if(ItemDto.TypeVirtual.equals(type)){
			return PrizeTypeVirtual;
		}
		return -1;
	}
}
