package cn.com.duiba.order.center.api.remoteservice.orders.consumer;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;

import java.util.Date;

/**
 * Created by yansen on 16/7/22.
 */
public interface RemoteOrdersTextChangeService  {
    public long getSequenceID();

    public OrdersDto insert(OrdersDto order)throws Exception;

    /**
     * 更新订单再次输入及信息
     * @param orderDO
     * @return
     */
    public Integer updateAllowInputAndTips(Long orderId, Long consumerId, Boolean allowInput,String allowInputTips);

    /**
     * 更新订单错误信息，状态，错误类型
     * @param orderId
     * @param failType
     * @param status
     * @param errorMessage
     * @param error4Consumer
     * @param error4Developer
     * @param error4Admin
     * @return
     */
    public Integer updateErrorMessageAndFailType(Long orderId, Long consumerId, Integer failType,String errorMessage,
                                                 String error4Consumer,String error4Develper,String error4Admin);

    /**
     * 释放一张优惠劵
     * @param orderId
     */
    public void releaseCouponByOrderId(Long orderId, Long consumerId);

    /**
     * 更新上游订单
     * @param orderId
     * @param supplierOrderId
     * @return
     */
    public Integer updateSupplierOrderId(Long orderId, Long consumerId, Long supplierOrderId);

    /**
     * 更新开发者订单号
     * @param orderId
     * @param developBizId
     * @return
     */
    public Integer updateDevelopBizId(Long orderId, Long consumerId, String developBizId);

    /**
     * 更新通知
     * @param orderId
     * @param notify
     * @return
     */
    public Integer updateNotify(Long orderId, Long consumerId, Integer notify);

    /**
     * 更新最后发送时间
     * @param orderId
     * @param lastSendTime
     * @return
     */
    public Integer updateLastSendTime(Long orderId, Long consumerId, Date lastSendTime);


    /**
     * 更新错误提示字段
     * 如果某个字段为空，则不更新该字段
     * @param orderId
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     */
    public int updateErrorInfo(Long orderId, Long consumerId, String error4admin,
                               String error4developer, String error4consumer);

    public int updateSubOrderIdById(Long orderId, Long consumerId, Long subId);

    /**
     * 更新最终还款金额
     */
    public int updateConsumerPayBackPrice(Long orderId, Long consumerId, Long consumerPayBackPrice);
}
