package cn.com.duiba.order.center.api.remoteservice.orders.create;

import cn.com.duiba.dcommons.flowwork.RemotePlatformCouponGoodsTakeOrderService;
import cn.com.duiba.order.center.api.dto.orders.ObjectAddressDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.tools.DuibaEvent;

/**
 * Created by yansen on 16/8/12.
 */
public interface RemoteOrderCreateService {
    public OrdersDto createCouponOrder(DuibaEvent.RequestParams params, final ConsumerDO consumer, ItemKey key, final String chargeMode, final String developerBizId, Long couponId,
                                       final Long relationId, final Integer relationType) throws Exception;

    public OrdersDto createAlipayOffcialOrder(DuibaEvent.RequestParams params, ConsumerDO consumer, ItemKey key, String chargeMode, String developerBizId,
                                              Long relationId, Integer relationType, Integer actualPrice, Integer price, Boolean isDuiba, Integer quantity, String alipay, String realname, SupplierProductDto sp) throws Exception;

    public OrdersDto createHuichangAlipayCodeOrder(DuibaEvent.RequestParams params, ConsumerDO consumer, ItemKey key, Integer actualPrice, Integer price, Integer quantity, String phone, String chargeMode, String developerBizId, SupplierProductDto sp) throws Exception;

    public OrdersDto createObjectOrder (ObjectAddressDto address, ItemKey key, DuibaEvent.RequestParams params, ConsumerDO consumer, Integer tempActualPrice, Long appItemId, Long itemIdd, String chargeMode, String developerBizId, Long relationId, Integer relationType) throws Exception;

    public OrdersDto createOufeiPhoneflowOrder(DuibaEvent.RequestParams params, ConsumerDO consumer, ItemKey key, Integer actualPrice, Long consumerId, String phone, String mobile, String province, SupplierProductDto product, String chargeMode, String developerBizId) throws Exception;

    public OrdersDto createPcgCouponOrder(RemotePlatformCouponGoodsTakeOrderService.PcgOrderParam param)throws Exception;

    public OrdersDto createPhoneBillOrder(DuibaEvent.RequestParams params, ItemKey key, Integer actualPrice, Integer facePrice, Boolean isDuiba, ConsumerDO consumer, Integer quantity, String phone, String mobile, String province, String chargeMode, String developerBizId, Long relationId, Integer relationType, Long appItemId, Long itemId, String type, SupplierProductDto sp) throws Exception;

    public OrdersDto createQBOrder(DuibaEvent.RequestParams params, Integer actualPrice, ItemKey key, ConsumerDO consumer, Boolean isDuiba, Integer quantity, String qq, String chargeMode, String developerBizId, Long relationId, Integer relationType, SupplierProductDto sp) throws Exception;

    public OrdersDto createVirtualOrder(DuibaEvent.RequestParams requestParams, ItemKey key, AppItemDO ai, ConsumerDO consumer, String degreeStr, Long appItemId, String bizParams, String chargeMode, Long relationId, Integer relationType, String developerBizId) throws Exception;
}
