package cn.com.duiba.order.center.api.dto.flowwork;

import java.io.Serializable;

public class AlipayOrderResponseDetail implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = -7538784182665020094L;
	private String alipay;
	private String orderNum;
	private String realname;
	private String price; //元为单位
	private String flag;//F 失败，T成功
	private String reason;
	private String alipayInnerId;
	private String finishTime;
	
	public AlipayOrderResponseDetail(String detail){
		String[] v=detail.split("\\u005E");
		orderNum=v[0];
		alipay=v[1];
		realname=v[2];
		price=v[3];
		flag=v[4];
		reason=v[5];
		alipayInnerId=v[6];
		finishTime=v[7];
	}
	
	@Override
	public String toString() {
		return alipay+","+orderNum+","+realname+","+price+","+flag+","+reason+","+alipayInnerId+","+finishTime;
	}
	
	public boolean isSuccess(){
		return "S".equalsIgnoreCase(flag);
	}

	public String getAlipay() {
		return alipay;
	}

	public String getOrderNum() {
		return orderNum;
	}

	public String getRealname() {
		return realname;
	}

	public String getPrice() {
		return price;
	}

	public String getFlag() {
		return flag;
	}

	public String getReason() {
		return reason;
	}

	public String getAlipayInnerId() {
		return alipayInnerId;
	}

	public String getFinishTime() {
		return finishTime;
	}
	
}
