package cn.com.duiba.order.center.api.dto.order_process;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by yansen on 16/7/13.
 */
public class RechargeOrdersDto implements Serializable{

    private static final long serialVersionUID = -1374981016477992874L;

    public static final String StatusCreate = "create"; // 创建订单
    public static final String StatusSuccess = "success";// 第三方充值成功
    public static final String StatusFail = "fail";// 第三方充值失败
    public static final String StatusCharged = "charged"; // 本地记账

    public static final String TradeWaitPay = "TRADE_WAIT_PAY";
    public static final String TradeFinished = "TRADE_FINISHED";
    public static final String TypeEbatong="ebatong";// 贝付科技 充值

    public static final String JsonKey_AccountType = "accountType";//用户的充值类型 枚举:company self
    public static final String JsonKey_Name = "name";//公司的名称或者个人用户的真实姓名
    public static final String JsonKey_License = "license";//公司的营业执照号
    public static final String JsonKey_Time = "time";//公司的执照到期时间
    public static final String JsonKay_IdNum = "idNum";//个人用户的身份证号

    private Long id;
    private String orderNum;// 订单号
    private Long devId;// 开发者ID

    private String devIp; // 充值用户IP
    private String defaultBank;// 默认银行

    private String type;// 充值类型 贝付科技：ebatong

    private Long totalFee; // 总价 单位分 上游提交的金额 包含手续费
    private Long chargeMoney; // 充值金额
    private String payUrl;// 充值连接
    private String tradeStatus;// 上游处理状态
    private String tradeNo;// 上游订单号
    private String supplierInfo;

    private String status;// 处理中 成功 失败
    private String errorMessage;// 系统错误
    private String failReason;// 失败原因，主要是给用户看的

    private Date finishTime; // 订单结束时间

    private String brief;

    private Date gmtCreate;
    private Date gmtModified;

    public RechargeOrdersDto() {
    }

    public RechargeOrdersDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }

    public RechargeOrdersDto(boolean init4insert) {
        if (init4insert) {
            gmtCreate = new Date();
            gmtModified = gmtCreate;
        }
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public Long getDevId() {
        return devId;
    }

    public void setDevId(Long devId) {
        this.devId = devId;
    }

    public String getDevIp() {
        return devIp;
    }

    public void setDevIp(String devIp) {
        this.devIp = devIp;
    }

    public String getDefaultBank() {
        return defaultBank;
    }

    public void setDefaultBank(String defaultBank) {
        this.defaultBank = defaultBank;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getTotalFee() {
        return totalFee;
    }

    public void setTotalFee(Long totalFee) {
        this.totalFee = totalFee;
    }

    public Long getChargeMoney() {
        return chargeMoney;
    }

    public void setChargeMoney(Long chargeMoney) {
        this.chargeMoney = chargeMoney;
    }

    public String getPayUrl() {
        return payUrl;
    }

    public void setPayUrl(String payUrl) {
        this.payUrl = payUrl;
    }

    public String getTradeStatus() {
        return tradeStatus;
    }

    public void setTradeStatus(String tradeStatus) {
        this.tradeStatus = tradeStatus;
    }

    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getSupplierInfo() {
        return supplierInfo;
    }

    public void setSupplierInfo(String supplierInfo) {
        this.supplierInfo = supplierInfo;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getFailReason() {
        return failReason;
    }

    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }

    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}
