package cn.com.duiba.order.center.api.remoteservice.amb;

import cn.com.duiba.order.center.api.dto.amb.AmbExpressTemplateDto;

import java.util.List;
import java.util.Map;

public interface RemoteAmbExpressTemplateService {

	public AmbExpressTemplateDto find(Long id);

	/**
     * 新增记录
     *
     * @param entity
     * @return
     */
    public AmbExpressTemplateDto insert(AmbExpressTemplateDto entity);

    /**
     * 更新记录
     *
     * @param entity
     */
    public int update(AmbExpressTemplateDto entity);

    public List<AmbExpressTemplateDto> findPageList(Map<String, Object> params);

    public long findPageCount(Map<String, Object> params);

    public void deleteTemplateById(Long id);

    /**
     * @param appId
     * @param type
     */
    public List<AmbExpressTemplateDto> findByAppIdAndType(Long appId, String type);

    /**
     * @param appId
     * @param name
     */
    public AmbExpressTemplateDto findByAppIdAndName(Long appId, String name);

    public List<AmbExpressTemplateDto> findDuibaExpressTemplate();

    /**
     * @param name
     * @return
     */
    public AmbExpressTemplateDto findExpressTemplateByName(String name);


    Long matchExpressPrice(Long consumerId, Long expressTemplateId) throws Exception;

    Long matchExpressPrice(String addrProvince, String addrCity, String addrArea, Long expressTemplateId) throws Exception;
}
