package cn.com.duiba.order.center.api.remoteservice.amb;

import cn.com.duiba.order.center.api.dto.amb.AmbOrderFastDto;

import java.util.Date;
import java.util.List;

public interface RemoteAmbOrderFastService {

	/**
	 * 创建记录
	 */
	public AmbOrderFastDto insert(AmbOrderFastDto fastOrder);

	/**
	 * 根据 加速订单类型 主订单ID 删除
	 */
	public int deleteByTypeAndOrderId(Long orderId, String orderFastType);

	/**
	 * 根据 主订单ID 删除，用于订单结束（success fail）
	 */
	public int deleteByOrderId(Long orderId);

	/**
	 * 锁记录
	 */
	public AmbOrderFastDto findForUpdate(Long id);

	/**
	 * TODO
	 */
	public AmbOrderFastDto findByOrderIdAndType(Long orderId, String orderFastType);

	/**
	 * TODO
	 */
	public List<AmbOrderFastDto> findByTypeAndScanTime(String orderFastType);

	public List<AmbOrderFastDto> findExpiredByType(String orderFastType,int offset,int max);

	/**
	 * 待付款 30分钟
	 */
	public int createOrderFastWaitPay(Long orderId, Long consumerId, Date orderGmtCreate);

	/**
	 * 待收货 7天
	 */
	public int createOrderFastWaitReceive(Long orderId, Long consumerId);

	/**
	 * 已收货 7天
	 */
	public int createOrderFastReceived(Long orderId, Long consumerId);

	/**
	 * 待售后 7天
	 */
	public int createOrderFastWaitPostsale(Long orderId, Long consumerId);

	/**
	 * 同意售后 14天
	 */
	public int createOrderFastAfterAgree(Long orderId, Long consumerId);

	/**
	 * 订单总时间 60天
	 */
	public int createOrderFastMaxTime(Long orderId, Long consumerId);

	/**
	 * 删除 待付款 30分钟
	 */
	public int removeOrderFastWaitPay(Long orderId);

	/**
	 * 删除 待收货 7天
	 */
	public int removeOrderFastWaitReceive(Long orderId);

	/**
	 * 删除 已收货 7天
	 */
	public int removeOrderFastReceived(Long orderId);

	/**
	 * 删除 待售后 7天
	 */
	public int removeOrderFastWaitPostsale(Long orderId);

	/**
	 * 删除 同意售后 14天
	 */
	public int removeOrderFastAfterAgree(Long orderId);

	/**
	 * 删除 订单总时间 60天
	 */
	public int removeOrderFastMaxTime(Long orderId);

	/**
	 * 整个订单结束，删除所有加速表任务记录
	 */
	public int removeOrderFastAtFinish(Long orderId);

	/**
	 * 对加速订单上锁
	 */
	public AmbOrderFastDto lock(Long id);



}
