package cn.com.duiba.order.center.api.remoteservice.amb;

import cn.com.duiba.order.center.api.dto.amb.AmbPostsaleOrdersDto;

/**
 * Created by yansen on 16/8/18.
 */
public interface RemoteAmbPostsaleService {
    /**
     * 可否发起售后，填写内容前的验证
     */
    public void canSubmitPostsaleBeforeFill(Long orderId, Long consumerId) throws Exception;

    /**
     * 可否发起售后，填写内容后提交的验证
     */
    public void canSubmitPostsaleAfterFill(Long orderId, Long consumerId, Long postsaleMoney) throws Exception;

    /**
     * 提交售后
     */
    public void submit(AmbPostsaleOrdersDto postsaleOrder, Long consumerI) throws Exception;

    /**
     * 取消售后
     */
    public void cancel(Long orderId, Long consumerId) throws Exception;

    /**
     * 根据主订单ID，判断该笔订单是否曾经发起过售后
     */
    public boolean isSubmittedPostsale(Long orderId, Long consumerId) throws RuntimeException;

    /**
     * 用于页面展示是否可以发起售后
     */
    public boolean canSubmitPostsale4Page(Long orderId, Long consumerId) throws RuntimeException;
}
