package cn.com.duiba.order.center.api.remoteservice.orders.bigdata;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.orders.ActivityOrdersDto;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/7/20.
 */
public interface RemoteOrdersReadService {

    List<OrdersDto> findPageByDeveloperBizId(int offset, int max, String developerBizId);

    Long getCountByDeveloperBizId(String developerBizId);

    List<ActivityOrdersDto> findActivityOrdersPageForAdmin(Map<String, Object> queryMap);

    Integer findActivityOrdersPageCountForAdmin(Map<String, Object> queryMap);

    Integer countItemNum(long itemId, Date startTime);

    List<Long> findWaitAuditOrders(Map<String, Object> queryMap);

    //待发货订单
    List<Long> findWaitShippOrders(Map<String, Object> queryMap);

    //超时订单
    List<Long> findTimeoutOrders(Map<String, Object> queryMap);

    //抽奖超时订单
    List<Long> findLotteryTimeoutOrders(Map<String, Object> queryMap);

    //虚拟商品异常订单
    List<Long> findVirtualOrders(Map<String, Object> queryMap);

    //秒杀订单
    List<Long> findKillOrders(Map<String, Object> queryMap);


}
