package cn.com.duiba.order.center.api.remoteservice.orders.mirror;

import cn.com.duiba.order.center.api.dto.orders.ActivityOrdersDto;
import cn.com.duiba.order.center.api.dto.orders.ItemAppStatDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersPageInfoDto;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/7/20.
 */
public interface RemoteMasterOrdersMirrorBussinessService {
    /**
     * 获取APP今日订单数量,首页查询调用
     * @param appId
     * @param startDate
     * @param endDate
     * @return
     */
    public Integer doCountTodayOrderByAppId(Long appId, Date startDate, Date endDate);

    /**
     * 订单条件查询
     * @param pageInfo
     * @return
     */
    public List<OrdersDto> doSelectOrdersByInfo(OrdersPageInfoDto pageInfo);

    /**
     * 订单条件查询条数
     * @param pageInfo
     * @return
     */
    public Long doCountOrderByInfo(OrdersPageInfoDto pageInfo);

    /**
     * 开发者活动订单查询
     * @param queryMap
     * @return
     */
    public List<ActivityOrdersDto> doSelectActivityOrdersPage(Map<String, Object> queryMap);

    /**
     * 开发者活动订单查询条数
     * @param queryMap
     * @return
     */
    public Long doActivityOrdersPageCount(Map<String,Object> queryMap);

    /**
     * 分类查询订单itemId,type
     * @param appId
     * @param relationId
     * @param relationType
     * @return
     */
    public List<ItemAppStatDto> doSelectActivityItemApp(Long appId, Long relationId, Integer relationType);

    /**
     * 根据开发者订单查询
     * @param appId
     * @param developerBizId
     * @return
     */
    public OrdersDto doSelectOrderByDeveloperBiz(Long appId,String developerBizId);

    /**
     * 计算appItem限量库存
     * @param appId
     * @param appItemId
     * @param startTime
     * @return
     */
    public Integer doCountAppItemNum(Long appId,Long appItemId,Date startTime);

    /**
     * 查询app跑马灯效果
     * @param appId
     * @param ids
     * @param idsStr
     * @return
     */
    public List<OrdersDto> doFindAppOrderRuning(Long appId,List<Long> ids, String idsStr);


    public List<OrdersDto> findOrdersByGmtCreate(OrdersPageInfoDto pageInfo);

    public Long countOrdersByGmtCreate(OrdersPageInfoDto pageInfo);

    public Long countOrdersByFinishTime(OrdersPageInfoDto pageInfo);

    public List<OrdersDto> findOrdersByFinishTime(OrdersPageInfoDto pageInfo);

    public Integer findOrderCountByAppIdAndDate(Long appId, Date startDate, Date endDate);

    /**
     * 我的订单，根据创建时间查询
     * @param
     * @return
     */
    public List<OrdersDto> findOrdersByGmtCreate(Long appId, Date startDate, Date endDate, String itemType, String bizParams, Long consumerId, String orderId, String namelike, String exchangeStatus,Integer offset, Integer max);

    public Long countOrdersByGmtCreate(Long appId, Date startDate, Date endDate, String itemType, String bizParams, Long consumerId, String orderId, String namelike, String exchangeStatus);

    public Long countOrdersByFinishTime(Long appId, Date startDate, Date endDate, String itemType, String bizParams, Long consumerId, String orderId, String namelike, String exchangeStatus);
    /**
     * 我的订单，根据结束时间查询
     * @param
     * @return
     */
    public List<OrdersDto> findOrdersByFinishTime(Long appId, Date startDate, Date endDate, String itemType, String bizParams, Long consumerId, String orderId, String namelike, String exchangeStatus,Integer offset, Integer max);

    public List<OrdersDto> findOrdersByInfo(Long appId,String orderTimeType, Date startDate, Date endDate, String itemType, String bizParams, Long consumerId, String exchangeStatus,Integer offset, Integer max);

    public Long countOrderByInfo(Long appId,String orderTimeType, Date startDate, Date endDate, String itemType, String bizParams, Long consumerId, String exchangeStatus);

    public List<ActivityOrdersDto> findActivityOrdersPage(Long appId, Long relationId, Integer relationType, Integer offset, Integer max);

    public Long findActivityOrdersPageCount(Long appId,Long relationId,Integer relationType);

    public List<ItemAppStatDto> findActivityItemApp(Long appId, Long relationId, Integer relationType);

    public OrdersDto findByAppAndDeveloperBizId(Long appId,String developerBizId);

    public Integer countAppItemNum(Long appId,Long appItemId,Date startTime);

    public List<OrdersDto> findAllByIdsAndIdsStr(Long appId,List<Long> ids, String idsStr);
}
