package cn.com.duiba.order.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 活动订单接口
 * @author houwen
 */
public interface RemoteActivityOrderService {
	
    /**
     * 创建活动订单
     * @param activityOrderDto
     * @return
     */
    public DubboResult<String> createOrder(ActivityOrderDto orderDto);
     
    /**
     * 根据订单唯一编号查询订单
     * @param orderNum
     * @return
     */
	public DubboResult<ActivityOrderDto> findByOrderNum(String orderNum);
	
	/**
     * 订单扣积分成功
     * @param orderNum 订单唯一编号
     * @param optionDto 中奖奖项信息
     * @return
     */
    public DubboResult<Boolean> consumeCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId);
     
    /**
     * 订单扣积分失败
     * @param orderNum 订单唯一编号
     * @param optionDto 奖项信息（如谢谢参与或空）
     * @return
     */
    public DubboResult<Boolean> consumeCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer);
    
    /**
     * 订单扣积分成功
     * @param orderNum 订单唯一编号
     * @param optionDto 中奖奖项信息
     * @return
     */
    public DubboResult<Boolean> addCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId);
     
    /**
     * 订单扣积分失败
     * @param orderNum 订单唯一编号
     * @param optionDto 奖项信息（如谢谢参与或空）
     * @return
     */
    public DubboResult<Boolean> addCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer);
     
    /**
     * 订单置为待领奖状态
     * @param orderNum 订单唯一编号
     * @return
     */
    public DubboResult<Boolean> exchangeStatusToWait(String orderNum);
     
    /**
     * 订单置为领奖成功
     * @param orderNum 订单唯一编号
     * @return
     */
    public DubboResult<Boolean> exchangeStatusToSuccess(String orderNum);
     
    /**
     * 订单置为领奖失败
     * @param orderNum 订单唯一编号
     * @return
     */
    public DubboResult<Boolean> exchangeStatusToFail(String orderNum);
     
    /**
     * 订单置为未领奖过期
     * @param orderNum 订单唯一编号
     * @return
     */
    public DubboResult<Boolean> exchangeStatusToOverdue(String orderNum);
     
    /**
     * 根据订单唯一编号修改开发者订单号
     * @param orderNum 订单唯一编号
     * @param developerBizId 开发者订单号
     * @return
     */
    public DubboResult<Boolean> updateDeveloperBizId(String orderNum, String developerBizId);
    
    /**
     * 根据订单唯一编号修改加积分开发者订单号
     * @param orderNum 订单唯一编号
     * @param developerBizId 开发者订单号
     * @return
     */
    public DubboResult<Boolean> updateAddDeveloperBizId(String orderNum, String developerBizId);
     
    /**
     * 根据开发者订单号查询订单
     * @param appId 应用ID
     * @param developerBizId 开发者订单号
     * @return
     */
    public DubboResult<ActivityOrderDto> findByDeveloperBizId(Long appId,  String developerBizId);
     
    /**
     * 修改主订单号
     * @param orderNum 订单唯一编号
     * @param mainOrderNum 主订单唯一编号
     * @return
     */
    public DubboResult<Boolean> updateMainOrderNum(String orderNum, String mainOrderNum);
    
    /**
     * 用户参与兑吧活动次数
     * @param consumerId 用户ID
     * @param activityId 活动ID
     * @return
     */
    public DubboResult<Integer> findConsumerDuibaActivityNum(long consumerId, long duibaActivityId, String activityType);
    
    /**
     * 用户参与兑吧活动订单明细
     * @param consumerId 用户ID
     * @param duibaActivityIds 活动ID集合
     * @return Map<Long, Integer> key:活动ID, value:参与次数
     */
    public DubboResult<List<ActivityOrderDto>> findConsumerDuibaActivityNumList(long consumerId, List<Long> duibaActivityIds, String activityType);
    
    /**
     * 根据订单号批量查询订单
     * @param consumerId
     * @param orderNums
     * @return
     */
    public DubboResult<List<ActivityOrderDto>> findByInOrderNums(long consumerId, List<String> orderNums);
    
    /**
     * 根据过期时间查询未领奖的活动订单
     * @param expirationTime 过期时间
     * @param activityType 活动类型
     * @return orderNum队列
     */
    public DubboResult<List<String>> findByExpirationTime(String expirationTime,String activityType);

}
