package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by yansen on 16/9/21.
 */
public interface RemoteOrderFlowworkStatusChangeService {

    /**扣费节点新增方法
     * @throws BusinessException
     */
    public DubboResult<Integer> changeCreate2DeveloperPay(Long orderId, Long consumerId);
    /**扣费节点新增方法
     * @throws BusinessException
     */
    public DubboResult<Integer> changeDeveloperPay2DuibaPay(Long orderId, Long consumerId);
    /**扣费节点新增方法
     * @throws BusinessException
     */
    public DubboResult<Integer> changeDuibaPay2ConsumeCredits(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeConsumeCredits2ConsumerPay(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeConsumerPay2Audit(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeAudit2SupplierExchange(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeSupplierExchange2AfterSend(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeAfterSend2Success(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeCreate2Fail(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeConsumeCredits2Fail(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeConsumerPay2Fail(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeCreate2Fail(Long orderId, Long consumerId, String error4consumer);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeAfterSend2Fail(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeDuibaPay2Fail(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeDeveloperPay2Fail(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeAudit2Fail(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeSupplierExchange2Fail(Long orderId, Long consumerId);
    /**
     * 强制从 strated -> complete
     * @param orderId
     * @return
     * @throws BusinessException
     */
    public DubboResult<Integer> markCreateComplete(Long orderId, Long consumerId);
    /**
     * 从started -> complete
     * @param orderId
     * @return
     * @throws BusinessException
     */
    public DubboResult<Integer> markDeveloperPayComplete(Long orderId, Long consumerId);

    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> markDuibaPayComplete(Long orderId, Long consumerId);
    /**
     * 强制从 strated -> complete
     * @param orderId
     * @return
     * @throws BusinessException
     */
    public DubboResult<Integer> markConsumeCreditsComplete(Long orderId, Long consumerId);
    /**
     * 强制从 strated -> complete
     * @param orderId
     * @return
     * @throws BusinessException
     */
    public DubboResult<Integer> markConsumerPayComplete(Long orderId, Long consumerId);
    /**
     * 强制从 strated -> complete
     * @param orderId
     * @return
     * @throws BusinessException
     */
    public DubboResult<Integer> markAuditComplete(Long orderId, Long consumerId)throws Exception;
    /**
     * 强制从 strated -> complete
     * @param orderId
     * @return
     * @throws BusinessException
     */
    public DubboResult<Integer> markSupplierExchangeComplete(Long orderId, Long consumerId);
    /**
     * 强制从 strated -> complete
     * @param orderId
     * @return
     * @throws BusinessException
     */
    public DubboResult<Integer> markAfterSendComplete(Long orderId, Long consumerId);
    /**
     * 强制从 strated -> complete
     * @param orderId
     * @return
     * @throws BusinessException
     */
    public DubboResult<Integer> markSuccessComplete(Long orderId, Long consumerId);
    /**
     * 强制从 strated -> complete
     * @param orderId
     * @return
     * @throws BusinessException
     */
    public DubboResult<Integer> markFailComplete(Long orderId, Long consumerId);
    /**
     * 兼容处理老订单
     * 由于老订单的flowwork_stage = null
     * 这里需要将正确的flowwork_stage设置进去
     * @throws BusinessException
     */
    public DubboResult<Integer> compatibleOldOrderStatus(Long orderId, Long consumerId,String nodeTypeKey);

    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeCreate2FailStarted(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeAfterSend2FailStarted(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeConsumeCredits2FailStarted(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeConsumerPay2FailStarted(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeAudit2FailStarted(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeSupplierExchange2FailStarted(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeDeveloperPay2FailStarted(Long orderId, Long consumerId);
    /**
     * @throws BusinessException
     */
    public DubboResult<Integer> changeDuibaPay2FailStarted(Long orderId, Long consumerId);
}
