package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by yansen on 16/9/21.
 */
public interface RemoteOrderJumpService {
    /**
     * 创建订单started->兑吧付款complete
     * @throws BusinessException
     */
    public DubboResult<Integer> jumpCreateStarted2DuibaPayComplete(Long orderId, Long consumerId) ;

    /**
     * 创建订单started->开发都付款完成 complete
     * @throws BusinessException
     */
    public DubboResult<Integer> jumpCreateStarted2DeveloperPayComplete(Long orderId, Long consumerId);

    /**
     * 开发者付款  started-> 兑吧付款完成 complete
     * @throws BusinessException
     */
    public DubboResult<Integer> jumpDeveloperPayStarted2DuibaPayComplete(Long orderId, Long consumerId);
    /**
     * 扣积分started->用户付款complete
     * @throws BusinessException
     */
    public DubboResult<Integer> jumpConsumeCreditsStarted2ConsumerPayComplete(Long orderId, Long consumerId);
    /**
     * 扣积分started->审核complete
     * @throws BusinessException
     */
    public DubboResult<Integer> jumpConsumeCreditsStarted2AuditComplete(Long orderId, Long consumerId);
    /**
     * 上游兑换started->售后complete
     * @throws BusinessException
     */
    public DubboResult<Integer> jumpSupplierExchangeStarted2AfterSendComplete(Long orderId, Long consumerId);
}
