package cn.com.duiba.order.center.api.dto;


import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

/**
 * @author yansen
 */
public class ConsumerExchangeRecordDto implements Serializable{

    public static final int UNREAD = 1;//
	public static final int LUCKBAG = 2;
	public static final int TypeOrder = 1; // 普通的兑换订单而来
	public static final int TypeTurntable = 2; // 大转盘中奖订单而来
	public static final int TypeSingleLottery = 3;// 来源单品抽奖订单
	public static final int TypeManualLottery = 4;// 来源手动开奖订单
	public static final int TypeHdtoolLottery = 5;// 来源活动工具
	public static final int TypeGame = 6;// 来源游戏活动
	public static final int TypeQuestion = 7;// 来源答题活动
	public static final int TypeQuizz = 8;// 来源测试题
	public static final int TypeNgame = 10;// 来源新游戏
	public static final int TypeGameRecord = 9;//游戏记录
	public static final int TypeNgameRecord =11;//游戏记录
	public static final int TypeGuess = 12;// 来源新游戏
	public static final int TypeRob = 13;//来源今日必抢
	private static final long serialVersionUID = 5369184460594831014L;

	private Long id;
	private Long consumerId;
	private Integer type;
	private Long orderId;
	private Long relationId;
	private Date gmtCreate;
	private Date gmtModified;
	private Long switchs;
	private String json;
	private Date overDue;

	private String tableName;

	/**
	 * 构造函数
	 */
	public ConsumerExchangeRecordDto() {
		super();
	}

	/**
	 *
	 * @param id
     */
	public ConsumerExchangeRecordDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	/**
	 *
	 * @param init4insert
     */
	public ConsumerExchangeRecordDto(boolean init4insert) {
		if (init4insert) {
			gmtCreate = new Date();
			gmtModified = gmtCreate;
			switchs = (long) 0;
			Calendar cal = Calendar.getInstance();
			cal.add(Calendar.YEAR, 100);
			overDue = cal.getTime();
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getRelationId() {
		return relationId;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Long getSwitchs() {
		return switchs;
	}

	public void setSwitchs(Long switchs) {
		this.switchs = switchs;
	}

	/**
	 *
	 * @param type
	 * @return
     */
	public boolean getSwitchs(Integer type) {
		int v = 1 << type;
		long ret = switchs & v;
		return ret != 0;
	}

	/**
	 *
	 * @param type
     */
	public void disableSwitchs(Integer type) {
		int v = 1 << type;
		v = ~v;
		switchs = switchs & v;
	}

	/**
	 *
	 * @param type
     */
	public void enableSwitchs(Integer type) {
		int v = 1 << type;
		switchs = switchs | v;
	}

	public String getJson() {
		return json;
	}

	public void setJson(String json) {
		this.json = json;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public Date getOverDue() {
		return overDue;
	}

	public void setOverDue(Date overDue) {
		this.overDue = overDue;
	}
}
