package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by yansen on 16/9/22.
 * 主订单--用户维度拆分表--基础接口
 */
public interface RemoteConsumerOrderSimpleService {


    /**
     * 根据订单id和用户id查询订单
     * @param id
     * @param consumerId
     * @return
     */
    public DubboResult<OrdersDto> findById(Long id, Long consumerId);

    /**
     * 根据订单唯一编号查询订单
     * @param orderNum
     * @return
     */
    public DubboResult<OrdersDto> findByOrderNum(String orderNum);

    /**
     * 通过for update的方式查询订单
     * @param orderId
     * @param consumerId
     * @return
     */
    public DubboResult<OrdersDto> select4updatelock(Long orderId, Long consumerId);

    /**
     *
     * @param id
     * @return
     */
    DubboResult<OrdersDto> findById(Long id);
}
