package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.dcommons.flowwork.RemotePlatformCouponGoodsTakeOrderService;
import cn.com.duiba.order.center.api.dto.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.dto.RequestParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 普通兑换业务
 * @author zhaodongxue
 *
 */
public interface RemoteExchangeService {
	
	/**
	 * Qb
	 * @param orderDto
	 * @param supplierProductId
	 * @param params
     * @return
     */
	DubboResult<OrdersDto> createQbOrder(OrdersDto orderDto,Long supplierProductId, RequestParams params);
	
	/**
	 * alipay
	 * @param orderDto
	 * @param params
     * @return
     */
	DubboResult<OrdersDto> createAliPayOrder(OrdersDto orderDto, RequestParams params);
	
	/**
	 * phonebill
	 * @param orderDto
	 * @param supplierProductId
	 * @param params
     * @return
     */
	DubboResult<OrdersDto> createPhoneBillOrder(OrdersDto orderDto,Long supplierProductId, RequestParams params);
	
	/**
	 * coupon
	 * @param orderDto
	 * @param supplierProductId
	 * @param params
     * @return
     */
	DubboResult<OrdersDto> createCouponOrder(OrdersDto orderDto,Long supplierProductId, RequestParams params);

	/**
	 * pcgcoupon
	 * @param param
	 * @return
     */
	DubboResult<RemotePlatformCouponGoodsTakeOrderService.TakeOrderResult> createPcgOrder(RemotePlatformCouponGoodsTakeOrderService.PcgOrderParam param);

	/**
	 * 虚拟商品下单
	 * @param ordersDto
	 * @param ambSubOrdersDto
	 * @param degreeStr
	 * @param params
     * @return
     */
	DubboResult<OrdersDto> createVirtualOrder(OrdersDto ordersDto, AmbSubOrdersDto ambSubOrdersDto, String degreeStr, RequestParams params);

	/**
	 *
	 * @param orderDto
	 * @param supplierProductId
	 * @param params
     * @return
     */
	DubboResult<OrdersDto> createPhoneflowOrder(OrdersDto orderDto,
												Long supplierProductId, RequestParams params);

	
	/*
	 * Material object
	 */
	

}
