package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.dto.SupplierOrderDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by yansen on 16/10/9.
 */
public interface RemoteTransactionBoService {
    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    public DubboResult<Boolean> doMakeConsumeSuccess(Long orderId, Long consumerId);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param failType
     * @param error4consumer
     * @param error4developer
     * @param error4admin
     * @return
     */
    public DubboResult<Boolean> doMakeConsumeFail(Long orderId, Long consumerId, Integer failType, String error4consumer, String error4developer, String error4admin);

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    public DubboResult<Boolean> doAmbPaySuccess(Long orderId, Long consumerId);

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    public DubboResult<Boolean> doAuditReject(Long orderId, Long consumerId) ;

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    public DubboResult<Boolean> doMakeSuccess(Long orderId, Long consumerId) ;

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    public DubboResult<Boolean> doMakeFail(Long orderId, Long consumerId) ;

    /**
     *
     * @param orderId
     * @param consumerId
     * @param supplierOrder
     * @param bizParams
     * @param brief
     * @return
     */
    public DubboResult<Boolean> doUpdateAllowInputUsed(Long orderId, Long consumerId,
                                          SupplierOrderDto supplierOrder, String bizParams, String brief);

    /**
     *
     * @param orders
     * @return
     */
    public DubboResult<Void> createPayBackRecordAtMakeFail(OrdersDto orders);

}
