package cn.com.duiba.order.center.api.dto;

import cn.com.duiba.order.center.api.tool.MD5;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.Date;


public class TakeOrderQueueDto implements Serializable{

	private static final long serialVersionUID = 378221462362416885L;
	private static Logger log= LoggerFactory.getLogger(TakeOrderQueueDto.class);

	private Long id;
	
	private Long consumerId;
	
	private Long appItemId;
	
	private Long itemId;
	
	private String ip;
	
	private String userAgent;
	
	private String cookies;
	
	private String batchId;
	
	private String address;
	
	private Long relationId;
	
	private Integer relationType; 
	
	private Date gmtCreate;
	
	private Date gmtModified;
	
	public static boolean isSecondKill(ItemKey itemKey){
		if (itemKey.getItem() != null && itemKey.getItem().isOpTypeItem(ItemDO.OpTypeTimeLimit) && itemKey.getItem().isOpTypeItem(ItemDO.OpTypeQuantityLimit)) {
			return true;
		} else if (itemKey.getAppItem() != null && itemKey.getAppItem().isOpTypeAppItem(ItemDO.OpTypeTimeLimit) && itemKey.getAppItem().isOpTypeAppItem(ItemDO.OpTypeQuantityLimit)) {
			return true;
		}
		return false;
	}
	/**
	 * appItemId(or itemId)+startTime+endTime+quantity
	 * @param itemKey
	 * @return
	 */
	public static String generateBatchId(ItemKey itemKey){
		String batchId=null;
		if(isSecondKill(itemKey)){
			if (itemKey.getItem() != null && itemKey.getItem().isOpTypeItem(ItemDO.OpTypeTimeLimit) && itemKey.getItem().isOpTypeItem(ItemDO.OpTypeQuantityLimit)) {
				String value="item-" + itemKey.getItem().getId()+"-"+itemKey.getItem().getLimitTimeBetween()+"-"+ itemKey.getItem().getLimitEverydayQuantity();
				try {
					batchId= MD5.md5(value);
				} catch (Exception e) {
					log.error("MD5.md5 error",e);
				}
			} else if (itemKey.getAppItem() != null && itemKey.getAppItem().isOpTypeAppItem(ItemDO.OpTypeTimeLimit) && itemKey.getAppItem().isOpTypeAppItem(ItemDO.OpTypeQuantityLimit)) {
				String value="appItem-" + itemKey.getAppItem().getId()+"-"+itemKey.getAppItem().getLimitTimeBetween()+"-"+ itemKey.getAppItem().getLimitEverydayQuantity();
				try {
					batchId=MD5.md5(value);
				} catch (Exception e) {
					log.error("MD5.md5 error",e);
				}
			}
		}
		
		return batchId;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public Long getAppItemId() {
		return appItemId;
	}

	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getUserAgent() {
		return userAgent;
	}

	public void setUserAgent(String userAgent) {
		this.userAgent = userAgent;
	}

	public String getCookies() {
		return cookies;
	}

	public void setCookies(String cookies) {
		this.cookies = cookies;
	}

	public String getBatchId() {
		return batchId;
	}

	public void setBatchId(String batchId) {
		this.batchId = batchId;
	}
	public String getAddress() {
		return address;
	}
	public void setAddress(String address) {
		this.address = address;
	}
	public Long getRelationId() {
		return relationId;
	}
	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}
	public Integer getRelationType() {
		return relationType;
	}
	public void setRelationType(Integer relationType) {
		this.relationType = relationType;
	}
}
