package cn.com.duiba.order.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by yansen on 16/9/22.
 * 主订单--用户维度拆分表--基础接口
 */
public interface RemoteConsumerOrderSimpleService {


    /**
     * 根据订单id和用户id查询订单
     * @param id
     * @param consumerId
     * @return
     */
    public DubboResult<OrdersDto> findById(Long id, Long consumerId);
    
    /**
     * 根据多个id查询订单--警告调用者list长度不宜过长
     * @param ids
     * @param consumerId
     * @return
     */
    DubboResult<List<OrdersDto>> findByIds(List<Long> ids, Long consumerId);
    
    /**
     * 根据多个id查询订单，返回数据和sequence顺序一致--警告调用者list长度不宜过长
     * @param ids
     * @param sequence id逗号隔开，返回数据的顺序和sequence顺序一致
     * @param consumerId
     * @return
     */
    DubboResult<List<OrdersDto>> findByIdsInSequence(List<Long> ids, String sequence, Long consumerId);

    /**
     * 根据订单唯一编号查询订单
     * @param orderNum
     * @return
     */
    public DubboResult<OrdersDto> findByOrderNum(String orderNum);

    /**
     * 通过for update的方式查询订单
     * @param orderId
     * @param consumerId
     * @return
     */
    public DubboResult<OrdersDto> select4updatelock(Long orderId, Long consumerId);

    /**
     *
     * @param id
     * @return
     */
    DubboResult<OrdersDto> findById(Long id);
}
