package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.dcommons.flowwork.RemotePlatformCouponGoodsTakeOrderService;
import cn.com.duiba.order.center.api.dto.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.MaiLaParamDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.dto.RequestParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 普通兑换业务
 * @author zhaodongxue
 *
 */
@AdvancedFeignClient
public interface RemoteExchangeService {
	
	/**
	 * Q币下单
	 * @param orderDto
	 * @param supplierProductId
	 * @param params
     * @return
     */
	DubboResult<OrdersDto> createQbOrder(OrdersDto orderDto,Long supplierProductId, RequestParams params);
	
	/**
	 * 支付宝下单
	 * @param orderDto
	 * @param params
     * @return
     */
	DubboResult<OrdersDto> createAliPayOrder(OrdersDto orderDto, RequestParams params);
	
	/**
	 * 话费下单
	 * @param orderDto
	 * @param supplierProductId
	 * @param params
     * @return
     */
	DubboResult<OrdersDto> createPhoneBillOrder(OrdersDto orderDto,Long supplierProductId, RequestParams params);
	
	/**
	 * 优惠券下单
	 * @param orderDto
	 * @param couponId
	 * @param params
     * @return
     */
	DubboResult<OrdersDto> createCouponOrder(OrdersDto orderDto,Long couponId, RequestParams params);

	/**
	 * 平台券下单
	 * @param param
	 * @return
     */
	DubboResult<RemotePlatformCouponGoodsTakeOrderService.TakeOrderResult> createPcgOrder(RemotePlatformCouponGoodsTakeOrderService.PcgOrderParam param);

	/**
	 * 麦拉下单
	 * @param param
	 * @param request
     * @return
     */
	DubboResult<String> createMaiLaOrder(MaiLaParamDto param, RequestParams request);

	/**
	 * 虚拟商品下单
	 * @param ordersDto
	 * @param ambSubOrdersDto
	 * @param degreeStr
	 * @param params
     * @return
     */
	DubboResult<OrdersDto> createVirtualOrder(OrdersDto ordersDto, AmbSubOrdersDto ambSubOrdersDto, String degreeStr, RequestParams params);

	/**
	 * 流量下单
	 * @param orderDto
	 * @param supplierProductId
	 * @param params
     * @return
     */
	DubboResult<OrdersDto> createPhoneflowOrder(OrdersDto orderDto,
												Long supplierProductId, RequestParams params);

	/**
	 * 实物下单
	 * @param orderDto
	 * @param ambSubOrdersDto
	 * @param params
     * @return
     */
	DubboResult<OrdersDto> createObjectOrder(OrdersDto orderDto,AmbSubOrdersDto ambSubOrdersDto, RequestParams params);

}
