package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.OrdersFasterDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * Created by yansen on 16/9/23.
 */
@AdvancedFeignClient
public interface RemoteOrdersFasterSimpleService {
    /**
     *
     * @param ordersFasterDto
     * @return
     */
    public DubboResult<OrdersFasterDto> insert(OrdersFasterDto ordersFasterDto);

    /**
     *
     * @param orderId
     * @param fasterType
     * @return
     */
    public DubboResult<OrdersFasterDto> findByOrderIdAndFastertype(Long orderId, Integer fasterType);

    /**
     *
     * @param id
     * @param lastSendTime
     * @return
     */
    public DubboResult<Integer> updateLastSendTime(Long id, Date lastSendTime);

    /**
     *
     * @param orderId
     * @param fasterType
     * @return
     */
    public DubboResult<Integer> deleteOrderByOrderIdAndFasterType(Long orderId, Integer fasterType);

    /**
     *
     * @param fasterType
     * @return
     */
    public DubboResult<List<OrdersFasterDto>> findHuiChangeAndSuDuDaTimeOutOrder(Integer fasterType);

    /**
     *
     * @param orderId
     * @return
     */
    public DubboResult<Void> deleteOrderFast(Long orderId);
}
