package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.order.center.api.dto.ActivityOrdersDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.paramquery.ActivityOrdersPageQuery;
import cn.com.duiba.order.center.api.paramquery.OrdersAppSearchQuery;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * 主订单--开发者维度拆分表--基础接口
 * @author zhaodongxue
 *
 */
@AdvancedFeignClient
public interface RemoteMirrorOrderSimpleService {

	/**
	 *
	 * @param orderId
	 * @param appId
	 * @return
     */
	DubboResult<OrdersDto> findByOrderId(Long orderId, Long appId);

	/**
	 *
	 * @param ids
	 * @param appId
     * @return
     */
	DubboResult<List<OrdersDto>> findByOrderIds(List<Long> ids, Long appId);

	/**
	 *
	 * @param orderNum
	 * @param appId
     * @return
     */
	DubboResult<OrdersDto> findByOrderNum(String orderNum, Long appId);

	/**
	 *
	 * @param orderNums
	 * @param appId
     * @return
     */
	DubboResult<List<OrdersDto>> findByOrderNums(List<String> orderNums, Long appId);

	/**
	 *
	 * @param appId
	 * @param developerBizId
     * @return
     */
	DubboResult<OrdersDto> findByAppAndDeveloperBizId(Long appId, String developerBizId);

	/**
	 *
	 * @param appId
	 * @param startDate
	 * @param endDate
	 * @param lastId
	 * @param size
     * @return
     */
	DubboResult<List<OrdersDto>> findByAppAndDate(Long appId, Date startDate, Date endDate, Long lastId, Long size);

	/**
	 *
	 * @param ordersAppSearchQuery
	 * @return
     */
	DubboResult<List<OrdersDto>> findOrdersByGmtCreate(OrdersAppSearchQuery ordersAppSearchQuery);

	DubboResult<List<OrdersDto>>findOrdersByFinishTime(OrdersAppSearchQuery ordersAppSearchQuery);

	DubboResult<Long> countOrdersByFinishTime(OrdersAppSearchQuery ordersAppSearchQuery);

	DubboResult<Long> countOrdersByGmtCreate(OrdersAppSearchQuery ordersAppSearchQuery);

	DubboResult<Long> findActivityOrdersPageCountByDay(ActivityOrdersPageQuery activityOrdersPageQuery);

	DubboResult<List<ActivityOrdersDto>> findActivityOrdersPageByDay(ActivityOrdersPageQuery activityOrdersPageQuery);

	DubboResult<Integer> findOrderCountByAppIdAndDate(Long appId, Date startDate, Date endDate);
	/**
	 *
	 * @param orderId
	 * @param appId
	 * @return
	*/
	DubboResult<Integer> updateOrderInfo(OrdersDto dto);
}
