package cn.com.duiba.order.center.api.dto;

import cn.com.duiba.order.center.api.constant.OrderPromoTypeEnum;

import java.io.Serializable;

/**
 *
 * @author JunAngLiu
 * @Title: OrderItemDto
 * @Description: 针对 多商品 订单  子订单 dto
 * @date 2018/6/2913:59
 */
public class OrderItemDto implements Serializable {

    private static final long serialVersionUID = 7648999033042607584L;
    private Integer credits;//子订单 消耗 总节分

    /**
     * 涉及到 价格 ，以 分 为单位
     * */
    private Integer price;//单价，以 分 为单位

    private Integer itemId;//商品id

    private Integer appSkuId; //兑吧skuId

    private Integer quantity;//数量

    private Integer appItemId;//开发者商品id

    private String itemBrief;//商品标题

    /**
     * 是否参与优惠， true 为参与
     * */
    private Boolean isPromotion ;

    private Integer totalPrice;//子订单 应付总价，以 分 为单位

    private Integer promotionPrice;//子订单优惠价格，以 分 为单位

    private Integer actualPrice;//子订单 实付总价，以 分 为单位

    private OrderPromoTypeEnum orderPromoTypeEnum; //优惠类型枚举

    private Integer promoActivityId; //营销活动ID



    public Boolean getPromotion() {
        return isPromotion;
    }

    public void setPromotion(Boolean promotion) {
        isPromotion = promotion;
    }

    public OrderPromoTypeEnum getOrderPromoTypeEnum() {
        return orderPromoTypeEnum;
    }

    public void setOrderPromoTypeEnum(OrderPromoTypeEnum orderPromoTypeEnum) {
        this.orderPromoTypeEnum = orderPromoTypeEnum;
    }

    public Integer getPromoActivityId() {
        return promoActivityId;
    }

    public void setPromoActivityId(Integer promoActivityId) {
        this.promoActivityId = promoActivityId;
    }

    public Integer getCredits() {
        return credits;
    }

    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public Integer getPrice() {
        return price;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public Integer getItemId() {
        return itemId;
    }

    public void setItemId(Integer itemId) {
        this.itemId = itemId;
    }

    public Integer getAppSkuId() {
        return appSkuId;
    }

    public void setAppSkuId(Integer appSkuId) {
        this.appSkuId = appSkuId;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Integer getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Integer appItemId) {
        this.appItemId = appItemId;
    }

    public String getItemBrief() {
        return itemBrief;
    }

    public void setItemBrief(String itemBrief) {
        this.itemBrief = itemBrief;
    }

    public Integer getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(Integer totalPrice) {
        this.totalPrice = totalPrice;
    }

    public Integer getPromotionPrice() {
        return promotionPrice;
    }

    public void setPromotionPrice(Integer promotionPrice) {
        this.promotionPrice = promotionPrice;
    }

    public Integer getActualPrice() {
        return actualPrice;
    }

    public void setActualPrice(Integer actualPrice) {
        this.actualPrice = actualPrice;
    }
}
