package cn.com.duiba.order.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by yansen on 16/9/23.
 */
public class OrdersFasterDto implements Serializable{
	private static final long serialVersionUID = -7519093620223918802L;
	
    //普通超时订单,指普通兑项流程产生的超时订单，不包含实物和优惠券订单，不包含大转盘和单品抽奖兑换项订单,目前排除了速度达和汇畅订单，
    //后期会把速度达和汇畅订单加入以简化操作
    public static final int FASTER_ORDER_TIMEOUT = 1;//直充类超时订单
    public static final int FASTER_ORDER_SUDUDA = 2;//速度达超时订单
    public static final int FASTER_ORDER_HUICHANGE = 3;//汇畅超时订单
    public static final int FASTER_ORDER_SHIPP_DUIBA = 4;//兑吧待发货订单
    public static final int FASTER_ORDER_SHIPP_DEV = 5;//开发者待发货订单
    public static final int FASTER_ORDER_AUDIT = 6;//待审核订单
    public static final int FASTER_ORDER_TURNTABLE = 7;//大转盘兑换异常订单
    public static final int FASTER_ORDER_SINGLELOTTERY = 8;//单品抽奖
    public static final int FASTER_ORDER_HDTOOLS = 9;//活动工具
    public static final int FASTER_ORDER_VIRTUAL=10;//虚拟商品超时订单
    public static final int FASTER_ORDER_CREDITS = 11;//秒杀扣积分异常订单
    public static final int FASTER_ORDER_GAME = 12;//游戏异常订单
    public static final int FASTER_ORDER_QUESTION = 13;//答题异常订单
    public static final int FASTER_ORDER_QUIZZ = 14;//测试题异常订单
    public static final int FASTER_ORDER_NGAME = 15;//新游戏异常订单
    public static final int FASTER_ORDER_GUESS = 16;//竞猜活动异常订单
    public static final int FASTER_ORDER_PLUGIN = 17; //插件活动异常订单
    public static final int FASTER_ORDER_SIGN = 18;//签到活动异常订单
    public static final int FASTER_ORDER_ALIPAY_EXCEPTION = 19; //支付宝异常订单
    
    private Long id;

    private Long appId;

    private Date gmtCreate;

    private Date gmtModified;

    private Date orderGmtCreate;

    private String type;//兑换项类型

    private Date lastSendTime;

    private Long orderId;//主订单id

    private String orderNum;//主订单号

    private Integer fasterType;//加速订单类型

    private String brief;

    private String developBizId;

    private Integer actualPrice;

    private Long consumerId;

    private String account;

    private Integer relationType;

    /**
     * 构造函数
     */
    public OrdersFasterDto(){
        super();
    }

    /**
     *
     * @param id
     */
    public OrdersFasterDto(Long id){
        this.id = id;
        this.gmtModified = new Date();
    }

    /**
     *
     * @param init4insert
     */
    public OrdersFasterDto(boolean init4insert){
        if(init4insert){
            gmtCreate = new Date();
            gmtModified = gmtCreate;
        }
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Date getOrderGmtCreate() {
        return orderGmtCreate;
    }

    public void setOrderGmtCreate(Date orderGmtCreate) {
        this.orderGmtCreate = orderGmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Date getLastSendTime() {
        return lastSendTime;
    }

    public void setLastSendTime(Date lastSendTime) {
        this.lastSendTime = lastSendTime;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public Integer getFasterType() {
        return fasterType;
    }

    public void setFasterType(Integer fasterType) {
        this.fasterType = fasterType;
    }

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public String getDevelopBizId() {
        return developBizId;
    }

    public void setDevelopBizId(String developBizId) {
        this.developBizId = developBizId;
    }

    public Integer getActualPrice() {
        return actualPrice;
    }

    public void setActualPrice(Integer actualPrice) {
        this.actualPrice = actualPrice;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Integer getRelationType() {
        return relationType;
    }

    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }

}
