package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.order.center.api.dto.DevAbnormalOrderDto;
import cn.com.duiba.order.center.api.dto.OrderFasterViewDto;
import cn.com.duiba.order.center.api.paramquery.OrdersWaitQuery;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 17/3/29.
 */
@AdvancedFeignClient
public interface RemoteOrdersFasterReadService {
    /**
     *
     * @param appId
     * @param itemTitle
     * @param receiverTel
     * @param consumerId
     * @param orderNum
     * @param startDate
     * @param endDate
     * @param isDevOrder
     * @param isDuibaOrder
     * @return
     */
    public DubboResult<Long> findDevWaitOrderFastCount(Long appId, String itemTitle, String receiverTel, Long consumerId, String orderNum, Date
            startDate, Date endDate, String isDevOrder, String isDuibaOrder);

    /**
     *
     * @param appId
     * @param orderNum
     * @param supplierBizId
     * @param consumerId
     * @param timeout
     * @return
     */
    public  DubboResult<Long> findVirtualAbnormalOrderCount(Long appId, String orderNum, String supplierBizId, Long consumerId, Date timeout);

    /**
     *
     * @param paramMap
     * @return
     */
    DubboResult<Long> findAuditOrderFastCount(Map<String, Object> paramMap);

    /**
     *
     * @param appId
     * @return
     */
    DubboResult<Integer> getAuditOrdersCount(Long appId);

    /**
     *
     * @param appId
     * @return
     */
    DubboResult<Long> getWaitOrdersCount(Long appId) ;

    /**
     *
     * @param appId
     * @param startDay
     * @param endDay
     * @return
     */
    DubboResult<Integer> getProcessingOrdersCount(Long appId, Date startDay, Date endDay) ;

    /**
     *
     * @param paramMap
     * @return
     */
    DubboResult<List<OrderFasterViewDto>> findAuditOrderFast(Map<String,Object> paramMap);

    /**
     *
     * @param ordersWaitQuery
     * @return
     */
    DubboResult<Map<String, Long>> getWaitRowAndMax(OrdersWaitQuery ordersWaitQuery);

    /**
     *
     * @param ordersWaitQuery
     * @return
     */
    DubboResult<List<Long>> findWaitExportOrderIds(OrdersWaitQuery ordersWaitQuery);

    /**
     *
     * @param appId
     * @param delayTime
     * @return
     */
    DubboResult<Integer> getVirtualAbnormalOrdersCount(Long appId, Date delayTime);

    /**
     *
     * @param ordersWaitQuery
     * @return
     */
    DubboResult<List<OrderFasterViewDto>> findDevWaitOrderFast(OrdersWaitQuery ordersWaitQuery);

    /**
     *
     * @param appId
     * @param orderNum
     * @param supplierBizId
     * @param consumerId
     * @param timeout
     * @param offset
     * @param max
     * @return
     */
    DubboResult<List<DevAbnormalOrderDto>> findVirtualAbnormalOrder(Long appId, String orderNum, String supplierBizId,
                                                       Long consumerId, Date timeout, Integer offset, Integer max);

    /**
     *
     * @param appId
     * @param orderNum
     * @return
     */
    DubboResult<List<OrderFasterViewDto>> findDevWaitOrderFastByOrderNum(Long appId, String orderNum);

}
