package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.ConsumerLimitRecordDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * RemoteConsumerExchangeLimitService
 */
@AdvancedFeignClient
public interface RemoteConsumerExchangeLimitService {

	/**
	 *
	 * @param record
	 * @return
     */
	DubboResult<Integer> consumerLimitRecordOnlyInsert(ConsumerLimitRecordDto record);

	/**
	 *
	 * @param records
	 * @return
	 */
	boolean batchConsumerRecordOnlyInsert(List<ConsumerLimitRecordDto> records);

	/**
	 *
	 * @param consumerId
	 * @param appItemId
	 * @param itemId
	 * @param orderId
     * @return
     */
	DubboResult<Integer> consumerLimitRecordOnlyDelete(Long consumerId, Long appItemId, Long itemId, Long orderId);

	/**
	 *
	 * @param ids
	 * @return
     */
	DubboResult<Integer> deleteByIds(List<Long> ids);

	/**
	 *
	 * @param overdue
	 * @param start
	 * @param pageSize
     * @return
     */
	DubboResult<List<ConsumerLimitRecordDto>> findPageByOverdue(Date overdue, Integer start, Integer pageSize);

	/**
	 *
	 * @param date
	 * @return
     */
	DubboResult<Long> findCountByOverdue(Date date);

	/**
	 *
	 * @param consumerId
	 * @param itemKey
     * @return
     */
	DubboResult<Integer> countByItemKey(Long consumerId, String itemKey);
}
