package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.order.center.api.dto.ActivityOrdersDto;
import cn.com.duiba.order.center.api.dto.ItemAppStatDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.paramquery.ActivityOrdersPageQuery;
import cn.com.duiba.order.center.api.paramquery.OrdersAppSearchQuery;
import cn.com.duiba.order.center.api.paramquery.Page;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * 主订单--开发者维度拆分表--基础接口
 * @author zhaodongxue
 *
 */
@AdvancedFeignClient
public interface RemoteMirrorOrderSimpleService {

	/**
	 *
	 * @param orderId
	 * @param appId
	 * @return
     */
	DubboResult<OrdersDto> findByOrderId(Long orderId, Long appId);

	/**
	 *
	 * @param ids
	 * @param appId
     * @return
     */
	DubboResult<List<OrdersDto>> findByOrderIds(List<Long> ids, Long appId);

	/**
	 *
	 * @param orderNum
	 * @param appId
     * @return
     */
	DubboResult<OrdersDto> findByOrderNum(String orderNum, Long appId);

	/**
	 *
	 * @param orderNums
	 * @param appId
     * @return
     */
	DubboResult<List<OrdersDto>> findByOrderNums(List<String> orderNums, Long appId);

	/**
	 *
	 * @param appId
	 * @param developerBizId
     * @return
     */
	DubboResult<OrdersDto> findByAppAndDeveloperBizId(Long appId, String developerBizId);

	/**
	 *
	 * @param appId
	 * @param startDate
	 * @param endDate
	 * @param lastId
	 * @param size
     * @return
     */
	DubboResult<List<OrdersDto>> findByAppAndDate(Long appId, Date startDate, Date endDate, Long lastId, Long size);

	/**
	 *
	 * @param ordersAppSearchQuery
	 * @return
     */
	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	DubboResult<List<OrdersDto>> findOrdersByGmtCreate(OrdersAppSearchQuery ordersAppSearchQuery);

	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	DubboResult<List<OrdersDto>>findOrdersByFinishTime(OrdersAppSearchQuery ordersAppSearchQuery);

	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	DubboResult<Long> countOrdersByFinishTime(OrdersAppSearchQuery ordersAppSearchQuery);

	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	DubboResult<Long> countOrdersByGmtCreate(OrdersAppSearchQuery ordersAppSearchQuery);

	DubboResult<Long> findActivityOrdersPageCountByDay(ActivityOrdersPageQuery activityOrdersPageQuery);

	DubboResult<List<ActivityOrdersDto>> findActivityOrdersPageByDay(ActivityOrdersPageQuery activityOrdersPageQuery);

	DubboResult<Integer> findOrderCountByAppIdAndDate(Long appId, Date startDate, Date endDate);

	DubboResult<Integer> updateOrderInfo(OrdersDto dto);

	List<ItemAppStatDto> groupDuibaActivityItem(ActivityOrdersPageQuery activityOrdersPageQuery);

	Page<OrdersDto> findOrderByApp(OrdersAppSearchQuery ordersAppSearchQuery);
}
