package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.constant.SubPaychannelType;
import cn.com.duiba.order.center.api.dto.AmbPaychannelOrdersDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.Date;
import java.util.List;

/**
 * 加钱购支付通道接口
 * Created by yansen on 16/9/26.
 */
@AdvancedFeignClient
public interface RemoteAmbPaychannelOrdersService {
    /**
     * @param id
     * @return
     */
    public DubboResult<AmbPaychannelOrdersDto> findById(Long id);

    /**
     * @param id
     * @param money
     * @return
     */
    public DubboResult<Integer> updatePayBackMoneyByIdAndStatusSuccess(Long id, Long money);


    /**
     * @param id
     * @param tradeNum
     * @return
     */
    public DubboResult<Integer> updatePayChannel4SuccessByIdAndWaitPay(Long id, String tradeNum);

    /**
     * @param id
     * @param tradeNum
     * @return
     */
    public DubboResult<Integer> updatePayChannelTradeNumByIdAndWaitPay(Long id, String tradeNum);

    /**
     * @param order
     * @param type
     * @return
     */
    public DubboResult<Integer> createAmbPayChannelOrder(OrdersDto order, String type);

    /**
     * 海底捞定制
     *
     * @param order
     * @param type
     * @param subPaychannelType
     * @return
     */
    @RequestMapping("/createAmbPayChannelOrderByHaidilao")
    public DubboResult<Integer> createAmbPayChannelOrder(OrdersDto order, String type, SubPaychannelType subPaychannelType);

    /**
     *
     */
    List<AmbPaychannelOrdersDto> findByParam(List<Long> developerIds, String status, Date endDate, Integer max);

    int updateSubPaychannelTypeById(Long id, SubPaychannelType subPaychannelType);
}
