package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.dcommons.flowwork.RemotePlatformCouponGoodsTakeOrderService;
import cn.com.duiba.order.center.api.dto.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.HaidilaoOrderDto;
import cn.com.duiba.order.center.api.dto.OrderItemDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.dto.OrdersDtoV2;
import cn.com.duiba.order.center.api.dto.RequestParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 普通兑换业务
 * @author zhaodongxue
 *
 */
@AdvancedFeignClient
public interface RemoteExchangeServiceV2 {

	/**
	 * Q币下单
	 * @param orderDto
	 * @param params
	 * @return
	 */
	OrdersDtoV2 createQbOrder(OrdersDtoV2 orderDto, RequestParams params);

	/**
	 * 支付宝下单
	 * @param orderDto
	 * @param params
     * @return
     */
	OrdersDtoV2 createAliPayOrder(OrdersDtoV2 orderDto, RequestParams params);
	
	/**
	 * 话费下单
	 * @param orderDto
	 * @param supplierProductId
	 * @param params
     * @return
     */
	OrdersDtoV2 createPhoneBillOrder(OrdersDtoV2 orderDto, Long supplierProductId, RequestParams params);
	
	/**
	 * 优惠券下单
	 * @param orderDto
	 * @param params
     * @return
     */
	OrdersDtoV2 createCouponOrder(OrdersDtoV2 orderDto, RequestParams params);

	/**
	 * 优惠券加钱购下单
	 * @param orderDto
	 * @param params
	 * @return
	 */
	OrdersDtoV2 createCouponAmbOrder(OrdersDtoV2 orderDto, RequestParams params, AmbSubOrdersDto ambSubOrdersDto);

	/**
	 * 虚拟商品下单
	 * @param ordersDto
	 * @param ambSubOrdersDto
	 * @param degreeStr
	 * @param params
     * @return
     */
	OrdersDtoV2 createVirtualOrder(OrdersDtoV2 ordersDto, AmbSubOrdersDto ambSubOrdersDto, String degreeStr, RequestParams params);

	/**
	 * 流量下单
	 * @param orderDto
	 * @param supplierProductId
	 * @param params
     * @return
     */
	OrdersDtoV2 createPhoneflowOrder(OrdersDtoV2 orderDto, Long supplierProductId, RequestParams params);

	/**
	 * 实物下单
	 * @param orderDto
	 * @param ambSubOrdersDto
	 * @param params
     * @return
     */
	OrdersDtoV2 createObjectOrder(OrdersDtoV2 orderDto, AmbSubOrdersDto ambSubOrdersDto, RequestParams params);

	/**
	 * 平台券下单
	 * @param param
	 * @return
	 */
	DubboResult<RemotePlatformCouponGoodsTakeOrderService.TakeOrderResult> createPcgOrder(RemotePlatformCouponGoodsTakeOrderService.PcgOrderParam param);

	/**
	 *  海底撈 定制  实物下单
	 * @param orderDto
	 * @param ambSubOrdersDto
	 * @param params
	 * @return
	 */
	OrdersDto createMallObjectOrder(HaidilaoOrderDto orderDto, AmbSubOrdersDto ambSubOrdersDto, RequestParams params);


	/**
	 * 获取商品
	 * @param orderDto
	 * @return
	 */
	OrderItemDto getOrderItemDto(OrdersDto orderDto);

}
