package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.OrderExtraDto;

import java.util.List;

/**
 * Created by zhangshun on 2018/12/3.
 */
@AdvancedFeignClient
public interface RemoteOrderExtraService {

    /**
     * 更新买家留言
     * @param orderExtra
     * @return
     */
    Boolean updateConsumerRemark(OrderExtraDto orderExtra);

    /**
     * 更新买家付款时间
     * @param orderExtra
     * @return
     */
    Boolean updateConsumerPayTime(OrderExtraDto orderExtra);

    /**
     * 更新买家付款时间
     * @param orderExtra
     * @return
     */
    Boolean updateConsumerCancelReason(OrderExtraDto orderExtra);


    /**
     * @param orderId
     * @return
     */
    OrderExtraDto getById(Long orderId);

    /**
     * 查询订单扩展信息
     * @return
     */
    OrderExtraDto getByOrderNum(String orderNum);

    /**
     * 增加商家留言
     * @return
     */
    int updateSellerRemark(OrderExtraDto orderExtraDto);

    /**
     * 根据订单id 列表查询扩展信息
     * @param orderIds
     * @return
     */
    List<OrderExtraDto> findByOrderIds(List<Long> orderIds);
}
