/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.api.tool;

import cn.com.duiba.order.center.api.constant.OrderTypeEnum;
import cn.com.duiba.order.center.api.constant.StatusIntEnum;
import cn.com.duiba.order.center.api.dto.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import java.util.Objects;

public class OrderUtils {
    private OrderUtils() {
    }

    public static Boolean isNewOrder(OrdersDto order) {
        return Objects.isNull(order.getAppItemId()) && Objects.isNull(order.getItemId());
    }

    public String getStatusDesc(OrdersDto dto, AmbSubOrdersDto subDto) {
        if ("ConsumerPay-started".equalsIgnoreCase(dto.getFlowworkStage())) {
            return StatusIntEnum.WAIT_PAY.getDesc();
        }
        if ("Audit-Started".equalsIgnoreCase(dto.getFlowworkStage())) {
            return StatusIntEnum.WAIT_AUDIT.getDesc();
        }
        if (OrderTypeEnum.OBJECT.getType().equals(dto.getType()) && "SupplierExchange-Started".equalsIgnoreCase(dto.getFlowworkStage())) {
            return StatusIntEnum.WAIT_SEND.getDesc();
        }
        if ("AfterSend-Started".equalsIgnoreCase(dto.getFlowworkStage())) {
            if (Objects.nonNull(subDto) && Objects.equals("received", subDto.getShipStatus())) {
                return StatusIntEnum.RECEIVE.getDesc();
            }
            return StatusIntEnum.WAIT_RECEIVE.getDesc();
        }
        if ("success".equalsIgnoreCase(dto.getStatus())) {
            return StatusIntEnum.SUCCESS.getDesc();
        }
        Integer statusInt = dto.getStatusInt();
        if (statusInt != null && statusInt >= StatusIntEnum.WAIT_PAY.getCode()) {
            if ("Fail-complete".equalsIgnoreCase(dto.getFlowworkStage())) {
                return StatusIntEnum.ofValue(statusInt);
            }
        } else if ("fail".equalsIgnoreCase(dto.getStatus()) || "Create-tofail".equalsIgnoreCase(dto.getFlowworkStage())) {
            return "\u5931\u8d25";
        }
        return StatusIntEnum.PROCESSING.getDesc();
    }
}

