package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.OrderItemDto;

import java.util.List;

/**
 * @author JunAngLiu
 * @Title: RemoteOrderItemService
 * @Description:
 * @date 2018/7/413:57
 */
@AdvancedFeignClient
public interface RemoteOrderItemService {

    /**
     * 根据 主订单id查询 子订单
     * @link  queryItemListByOderId
     * */
    @Deprecated
     List<OrderItemDto> queryByOderId(Long OrderId) throws BizException;

    /**
     * 根据 主订单id集合 批量 查询 子订单
     * @link  queryItemListByOrderIds
     * */
    @Deprecated
    List<OrderItemDto>queryByOrderIds(List<Long> orderIds,Long consumerId) throws BizException;


    /**
     * 根据 主订单id查询 子订单
     * */
    List<OrderItemDto> findByOrderIds(List<Long> orderIds);


    /**
     * 更新优惠券ID
     * @param orderId
     * @param consumerId
     * @param couponId
     * @return
     */
    Boolean updateCouponId(Long orderId, Long consumerId, Long couponId);

    /**
     * 更新子订单状态
     * 注意：如果ordersItemId子订单号不传，会更新主订单下面的所有子订单状态
     * @param orderId
     * @param consumerId
     * @param ordersItemId
     * @param status
     * @return
     */
    Boolean updateStatus(Long orderId,Long consumerId, Long ordersItemId, Integer status);

    List<Long> queryOrderItemIdByOrderId(Long orderId);

    /**
     * 根据itemId查询商品
     * @param itemId
     * @return
     */
    OrderItemDto queryByItemId(Long itemId);

    /**
     * 根据 主订单id查询 子订单
     * */
    List<OrderItemDto> queryItemListByOderId(Long orderId) ;

    /**
     * 根据 主订单id集合 批量 查询 子订单
     * */
    List<OrderItemDto>queryItemListByOrderIds(List<Long> orderIds,Long consumerId);



    /**
     * 仅试用新订单号 17年中旬以后（以订单号后4位进行分表的方式）
     * 仅根据 订单id集合 批量查询 ，特殊需求 才使用该接口
     * */
    List<OrderItemDto> findByIdsAndSuffix(List<Long> orderIds, String tableSuffix);
}
