package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.AlipayBatchLogDto;
import cn.com.duiba.order.center.api.paramquery.AabnormalOrderQueryParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 订单失败回滚数据处理
 * @author yangyukang
 * @date 2022.2.25
 */
@AdvancedFeignClient
public interface RemoteOrdersRollbackService {

    /**
     * 回滚开发者成本价
     * @param orderId
     * @param orderItemIds
     * @throws BizException
     */
    void rollbackActualPrice(Long orderId, List<Long> orderItemIds) throws BizException;

    /**
     * 回滚用户金额
     * @param orderId
     * @param orderItemIds
     * @param expressPrice  运费(预留字段，方便后期改造)
     * @throws BizException
     */
    void rollbackUserPrice(Long orderId, List<Long> orderItemIds, Long expressPrice) throws BizException;

    /**
     * 回滚用户积分
     * @param orderId
     * @param orderItemIds
     * @throws BizException
     */
    void rollbackUserCredits(Long orderId, List<Long> orderItemIds) throws BizException;

}
