/**
 * Project Name:goods-center-api
 * File Name:Page.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice.tool
 * Date:2016年5月23日下午1:49:13
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.order.center.api.paramquery;

import java.io.Serializable;
import java.util.List;

/**
 * 分页返回类
 * @author Administrator
 *
 * @param <T> clazz
 */
public class Page<T> implements Serializable {
    private static final long serialVersionUID = 3881553797523846598L;

    private int current;
    
    private int pageSize=20;
    
    private int totalPages;
    
    private long totalCount;
    
    /**
     * list
     */
    private List<T> list;
    
    /**
     * page
     * @param pageSize
     * @param current
     */
    public Page(int pageSize, int current){
        this.pageSize=pageSize;
        this.current=current;
    }

    public int getCurrent() {
        return current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getTotalPages() {
        return totalPages;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public List<T> getList() {
        return list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public long getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }
}

