package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.constant.OrderPromoTypeEnum;
import cn.com.duiba.order.center.api.dto.OrderPromotionDto;

import java.util.List;

/**
 * Created by sunyan on 2019/1/25.
 */
@AdvancedFeignClient
public interface RemoteOrderPromotionService {
    /**\
     * 根据主订单id集合查询
     * */
    List<OrderPromotionDto> queryListByOrderIdAndPromoType(Long orderId, OrderPromoTypeEnum orderPromoTypeEnum);

    /**
     * 根据主订单id列表查询
     *
     * @param orderIds
     * @return
     */
    List<OrderPromotionDto> queryListByOrderIdsAndPromoType(List<Long> orderIds, OrderPromoTypeEnum orderPromoTypeEnum);

    /**
     * 根据类型和用户id查询
     * @param promoType
     * @param consumerId
     * @return
     */
    List<OrderPromotionDto> queryByTypeAndConsumerId(Integer promoType,
                                                     Long consumerId);
}
