package cn.com.duiba.order.center.api.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum DeliveryStatusEnum {

    INCOMPLETE(1, "未发完"),
    COMPLETED(0, "已发完"),

    ;

    private final int    code;
    private final String desc;

    public static DeliveryStatusEnum getByCode(int code) {
        for (DeliveryStatusEnum value : values()) {
            if (value.code == code) {
                return value;
            }
        }
        throw new IllegalArgumentException("DeliveryStatusEnum code:" + code + " not exist");
    }

    public static DeliveryStatusEnum getByBoolean(boolean fullyDelivered) {
        return fullyDelivered ? COMPLETED : INCOMPLETE;
    }
}
