/**
 * Project Name:trade-center-api
 * File Name:RemoteAmbPostsaleService.java
 * Package Name:cn.com.duiba.order.center.api.remoteservice.amb
 * Date:2017年2月7日下午2:42:04
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.AmbPostsaleOrdersDto;
import cn.com.duiba.order.center.api.dto.PostsaleExpressDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * ClassName:RemoteAmbPostsaleService <br/>
 * Date:     2017年2月7日 下午2:42:04 <br/>
 * @author   admin
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteAmbPostsaleService {

    /**
     * 校验是否能发起售后
     *
     * @param orderId       兑吧订单号
     * @param consumerId    兑吧用户ID
     * @param postsaleMoney 退款金额
     * @return DubboResult
     */
    DubboResult<Void> checkSubmitPostsale(Long orderId, Long consumerId, Long postsaleMoney);

    DubboResult<Void> checkSubmitPostsaleNew(Long orderId, Long ordersItemId, Long consumerId, Long postsaleMoney, Long postsaleCredits);
    
    /**
     * 提交售后
     * @param postsaleOrder
     * @param consumerId
     * @return DubboResult
     */
    DubboResult<Void> submit(AmbPostsaleOrdersDto postsaleOrder, Long consumerId);

    /**
     * 提交售后
     * @param postsaleOrder
     * @param consumerId
     * @return DubboResult
     */
    DubboResult<Long> submitNew(AmbPostsaleOrdersDto postsaleOrder, Long consumerId);

    /**
     * 售后，用户寄回
     * @param postsaleExpressDto
     * @param postsaleOrderId
     * @param operateAppId
     * @throws BizException
     */
    void userSendBack(PostsaleExpressDto postsaleExpressDto, Long postsaleOrderId, Long operateAppId) throws BizException;
    
    /**
     * 取消售后 推存用cancelByOrderItemId，需要传子订单号
     * @param consumerId
     * @return DubboResult
     */
    @Deprecated
    DubboResult<Void> cancel(Long subOrderId,Long consumerId);

    /**
     *
     * @param orderId 主订单ID
     * @param orderItemId 子订单ID
     * @param consumerId
     * @throws BizException
     */
    void cancelByOrderItemId(Long orderId, Long orderItemId, Long consumerId) throws BizException;
    
    /**
     * 开发者同意售后
     * @param postsaleOrderId
     * @param dlpRemark
     * @param operateAppId
     * @return
     */
    DubboResult<Void> dlpAgree(Long postsaleOrderId, String dlpRemark, Long operateAppId);
    
    /**
     * 管理员同意售后
     * @param postsaleOrderId
     * @param mngRemark
     * @return
     */
    DubboResult<Void> mngAgree(Long postsaleOrderId, String mngRemark);
    
    /**
     * 开发者拒绝售后
     * @param postsaleOrderId
     * @param dlpRemark
     * @param operateAppId
     * @return
     */
    DubboResult<Void> dlpReject(Long postsaleOrderId, String dlpRemark, Long operateAppId);
    
    /**
     * 管理员拒接售后
     * @param postsaleOrderId
     * @param mngRemark
     * @return
     */
    DubboResult<Void> mngReject(Long postsaleOrderId, String mngRemark);
    
    /**
     * 开发者完成售后
     * @param postsaleOrderId
     * @param operateAppId
     * @return
     */
    DubboResult<Void> dlpComplete(Long postsaleOrderId, Long operateAppId);
    
    /**
     * 管理员完成售后
     * @param postsaleOrderId
     * @return
     */
    DubboResult<Void> mngComplete(Long postsaleOrderId);
    
    /**
     * 管理员售后成功操作
     * @param postsaleOrderIds
     * @return
     */
    DubboResult<Void> mngDoSuccessPostsales(List<Long> postsaleOrderIds);

    /**
     * 权益退款
     * 用户能直接退款，所以创建一笔同意的售后单，再调用通用售后完成接口
     * @return
     */
    DubboResult<Void> equityRefund(AmbPostsaleOrdersDto postsaleOrder,Long consumerId)throws BizException;

}

