package cn.com.duiba.order.center.api.constant;

import java.util.Arrays;
import java.util.Objects;

/**
 * 订单售后问题类型枚举
 *
 * @author ykb
 * @date 2023-02-15
 */
public enum OrderAfterSaleTypeEnum {

    TYPE_001(0, "取消订单"),
    TYPE_002(1, "修改收货信息"),
    TYPE_003(2, "物流问题反馈"),
    TYPE_004(3, "商品质量反馈"),
    TYPE_005(4, "其他"),

            ;


    OrderAfterSaleTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final Integer code;

    private final String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(Integer code) {
        return Arrays.stream(OrderAfterSaleTypeEnum.values()).filter(value -> Objects.equals(value.getCode(), code)).map(v -> v.desc).findFirst().orElse(null);
    }

    public static OrderAfterSaleTypeEnum getByCode(Integer code) {
        return Arrays.stream(OrderAfterSaleTypeEnum.values()).filter(value -> Objects.equals(value.getCode(), code)).findFirst().orElse(null);
    }

}
