package cn.com.duiba.order.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by yansen on 16/9/23.
 */
@Data
public class OrdersFasterDto implements Serializable{
	private static final long serialVersionUID = -7519093620223918802L;
	
    //普通超时订单,指普通兑项流程产生的超时订单，不包含实物和优惠券订单，不包含大转盘和单品抽奖兑换项订单,目前排除了速度达和汇畅订单，
    //后期会把速度达和汇畅订单加入以简化操作
    public static final int FASTER_ORDER_TIMEOUT = 1;//直充类超时订单
    public static final int FASTER_ORDER_SUDUDA = 2;//速度达超时订单
    public static final int FASTER_ORDER_HUICHANGE = 3;//汇畅超时订单
    public static final int FASTER_ORDER_SHIPP_DUIBA = 4;//兑吧待发货订单
    public static final int FASTER_ORDER_SHIPP_DEV = 5;//开发者待发货订单
    public static final int FASTER_ORDER_AUDIT = 6;//待审核订单
    public static final int FASTER_ORDER_TURNTABLE = 7;//大转盘兑换异常订单
    public static final int FASTER_ORDER_SINGLELOTTERY = 8;//单品抽奖
    public static final int FASTER_ORDER_HDTOOLS = 9;//活动工具
    public static final int FASTER_ORDER_VIRTUAL=10;//虚拟商品超时订单
    public static final int FASTER_ORDER_CREDITS = 11;//秒杀扣积分异常订单
    public static final int FASTER_ORDER_GAME = 12;//游戏异常订单
    public static final int FASTER_ORDER_QUESTION = 13;//答题异常订单
    public static final int FASTER_ORDER_QUIZZ = 14;//测试题异常订单
    public static final int FASTER_ORDER_NGAME = 15;//新游戏异常订单
    public static final int FASTER_ORDER_GUESS = 16;//竞猜活动异常订单
    public static final int FASTER_ORDER_PLUGIN = 17; //插件活动异常订单
    public static final int FASTER_ORDER_SIGN = 18;//签到活动异常订单
    public static final int FASTER_ORDER_ALIPAY_EXCEPTION = 19; //支付宝异常订单
    public static final int FASTER_ORDER_QB_EXCEPTION = 20; //Qb异常订单
    public static final int FASTER_ORDER_PROJECTX = 21; //星速台异常订单

    private Long id;

    private Long appId;

    private Date gmtCreate;

    private Date gmtModified;

    private Date orderGmtCreate;

    private String type;//兑换项类型

    private Date lastSendTime;

    private Long orderId;//主订单id

    private String orderNum;//主订单号

    private Integer fasterType;//加速订单类型

    private String brief;

    private String developBizId;

    private Integer actualPrice;

    private Long consumerId;

    private String account;

    private Integer relationType;

    /** 是否 被标记为已导出 0:否 1:是 */
    private Integer exportSign;

    /** 定制字段，由开发者自定义存放值 */
    private String customValue;

    /**
     * 构造函数
     */
    public OrdersFasterDto(){
        super();
    }

    /**
     *
     * @param id
     */
    public OrdersFasterDto(Long id){
        this.id = id;
        this.gmtModified = new Date();
    }

    /**
     *
     * @param init4insert
     */
    public OrdersFasterDto(boolean init4insert){
        if(init4insert){
            gmtCreate = new Date();
            gmtModified = gmtCreate;
        }
    }


}
