package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.AmbPostsaleOrderFasterDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 17/3/29.
 */
@AdvancedFeignClient
public interface RemoteAmbPostsaleOrderFasterService {
    /**
     * 必填参数 appId
     * 可选参数orderType,orderNumber,startTime,endTime,partnerUserId,itemTitle,postsaleStatus
     *
     * @param queryMap
     * @return
     */
    @Deprecated
    public Long findPageCountForDlp(Map<String, Object> queryMap);

    public Long findPageCountForDlpForDeveloperSupplier(Map<String, Object> queryMap);


    DubboResult<Long> findPageCountForDlpNew(Map<String, Object> queryMap);

    Long findPageCountForDuiBaNew(Map<String, Object> queryMap);

    DubboResult<List<AmbPostsaleOrderFasterDto>> findPage(Map<String, Object> queryMap);

    List<AmbPostsaleOrderFasterDto> findDuiBaPage(Map<String, Object> queryMap);

    @Deprecated
    /**
     * 推荐用findByOrdersItemId， 这个上线之后要丢弃
     */
    DubboResult<AmbPostsaleOrderFasterDto> findByOrderId(Long orderId);

    DubboResult<AmbPostsaleOrderFasterDto> findByOrdersItemId(Long orderId, Long ordersItemId);
    /**
     * 根据orderId查询当前售后订单记录
     * @param orderId
     * @return
     */
    List<AmbPostsaleOrderFasterDto> listByOrderId(Long orderId);

    List<AmbPostsaleOrderFasterDto> findByAppIdAndOrderIdsAndStatus(Long appId,
                                                                    List<Long> orderIds,
                                                                    String postsaleStatus);

     List<AmbPostsaleOrderFasterDto> findPostsalIngByCid(Long cid, Integer offset);

    /**
     * 查询主订单售后状态,true-售后中，false-售后完成
     * @param orderId
     * @return
     */
     Boolean findOrderPostSaleStatus(Long orderId);

    /**
     * 找到一组子订单中状态最早的状态
     */
    String findLeastAfterSaleStatusByOrderItemIdList(List<Long> orderItemIds);

    /**
     * 查询最新一条postsal_order_faster
     * @param orderId
     * @param ordersItemId
     * @return
     */
     AmbPostsaleOrderFasterDto findBestNewByOrderId(Long orderId, Long ordersItemId);

    /**
     * @param orderIdList
     * @return
     */
    List<AmbPostsaleOrderFasterDto> findByOrderIdList(List<Long> orderIdList);

}
