/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.api.paramquery.common;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PageParam
implements Serializable {
    private static final Pattern humpPattern = Pattern.compile("[A-Z]");
    protected Integer pageNo = 1;
    protected Integer pageSize = 20;
    protected String orderBy;
    protected String desc = "";

    public String getOrderBy() {
        return StringUtils.isBlank((CharSequence)this.orderBy) ? "" : PageParam.humpToLine2(this.orderBy) + " " + this.getDesc();
    }

    public String getOrderByWithoutLine() {
        return this.orderBy;
    }

    public String getDesc() {
        return this.desc;
    }

    public static String humpToLine2(String str) {
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public PageParam(Integer pageNo, Integer pageSize, String orderBy, String desc) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.orderBy = orderBy;
        this.desc = desc;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public PageParam() {
    }
}

