package cn.com.duiba.order.center.api.constant;

import java.util.Objects;

/**
 * @author qianjue
 * @date 2018/12/11
 * @description: 订单主类型枚举
 */
public enum EsCustomFieldEnum {

    SUPPLIERIDS( "supplierIds"),
    //优惠券订单
    CUSTOMSTRINGONE( "customStringOne"),
    //支付宝订单
    CUSTOMSTRINGTWO("customStringTwo"),
    //虚拟商品
    ;



    private String fieldName;

    public String getFieldName() {
        return fieldName;
    }


    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    private EsCustomFieldEnum(String type){
        this.fieldName = type;
    }

    public static EsCustomFieldEnum ofValue(String type){
        for (EsCustomFieldEnum orderEnum:values()){
            if (Objects.equals(orderEnum.getFieldName(),type)){
                return orderEnum;
            }
        }
       return null;
    }
}
