package cn.com.duiba.order.center.api.constant;

import java.util.Objects;

public enum StatusIntEnum {
    PROCESSING(-1,"处理中"),
    WAIT_PAY(100,"等待买家付款"),
    //预约商品等待抽签 预约商品特有逻辑
    WAIT_RESERVATION(101,"等待抽签"),
    GROUP_BUYING(150,"拼团中"),
    WAIT_AUDIT(200,"待商家审核"),
    WAIT_SEND(300,"等待卖家发货"),
    WAIT_RECEIVE(400,"卖家已发货"),
    RECEIVE(500,"已收货"),
    POST_SALE(600,"售后"),
    TIME_OUT(700,"已失效"),
    CANCEL(800,"已取消"),
    SUCCESS(900,"已完成"),
    ERROR(1000,"异常"),
    //兼容老数据用
    FAIL(1100,"失败"),
    ;

    private Integer code;
    private String desc;

    StatusIntEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    public static StatusIntEnum ofValue(int code){
        for (StatusIntEnum type : values()){
            if(Objects.equals(code,type.getCode())){
                return type;
            }
        }
        throw new UnsupportedOperationException("不支持的类型");
    }
    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
