package cn.com.duiba.order.center.biz.dao.activity;

import java.util.HashMap;
import java.util.Map;

import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BaseActivityOrderDao {

	@Autowired
	@Qualifier("activityOrdersConsumerSqlSessionTemplate")
	protected SqlSessionTemplate sqlSession;

	protected SqlSessionTemplate getSqlSession() {
		return sqlSession;
	}

	protected String getStamentNameSpace(String method) {
		return getClass().getName() + "." + method;
	}

	protected Map<String, Object> getBlankParams() {
		return new HashMap<String, Object>();
	}

	protected String getTableSuffix(Long id) {
		Long tbInt = id.longValue() % 1024;
		String tb = tbInt + "";
		if (tbInt < 10) {
			tb = "000" + tbInt;
		} else if (tbInt < 100) {
			tb = "00" + tbInt;
		} else if (tbInt < 1000) {
			tb = "0" + tbInt;
		}
		return tb;
	}
	
	protected String getTableSuffixByOrderNum(String orderNum) {
		String suffix = orderNum.substring(orderNum.length() - 4, orderNum.length());
		return suffix;
	}
	
}
